! GR_WLD_TO_DEV -- convert world coordinates to device coordinates

subroutine GR_WLD_TO_DEV( xw, yw, xd, yd )

   double precision, intent(in)  :: xw, yw
   double precision, intent(out) :: xd, yd
   !------ API end ------

   ! GRPCKG (internal routine): Convert scaled position to absolute position.
   !
   ! Arguments:
   !
   ! XW, YW : world coordinates.
   ! XD, YD : absolute device coordinates.
   !--
   ! (1-Feb-1983)
   ! 29-Feb-2020 - Use now double precision instead of single precision.
   !  6-Apr-2020 - Removed ABSXY argument (FALSE in all calling routines).
   ! 16-Mar-2021 - Changes name from GRTXY0 (what a strange name) to
   !               GR_WLD_TO_DEV.
   !-----------------------------------------------------------------------

   !------ end of declarations -- execution starts hereafter  ------

   xd = xw * grxscl(grcide) + grxorg(grcide)
   yd = yw * gryscl(grcide) + gryorg(grcide)

end subroutine
