/*.......................................................................
 * Converts from the coordinates sent by MFPLOT in ibuf[] to an
 * X-windows point in the coordinate system of the window.
 *
 * Input:
 *  xw      XWdev *   The MFPLOT /xw device descriptor.
 *  xy        int [2] Array of two integers containing MFPLOT coordinates
 *                    arranged as x followed by y.
 * Output:
 *  xp     XPoint *   The converted coordinates.
 */
static void xw_xy_to_XPoint ( XWdev *xw, int *xy, XPoint *xp ) {
  xp->x = xw->geom.xmin + xy[0];
  xp->y = xw->geom.ymax - xy[1];
}

