/*.......................................................................
 * Maps XColor intensities between 0 and COLORMULT to floating point color
 * intensities between 0.0 and 1.0. Numbers outside of this range are
 * limited to the nearest of the two limits.
 *
 * Input:
 *  unsigned short   The equivalent XColor RGB intensity.
 * Output:
 *  return  double   The MFPLOT normalized intensity to be converted.
 */
static double xw_xcolor_to_rgb ( unsigned short urgb ) {
  double rgb;   /* The output value */
  rgb = (double) urgb / (double) COLORMULT;
  /*
   * Check for limiting input values.
   */
  if(rgb < 0.0) return 0.0;
  if(rgb > 1.0) return 1.0;
  return rgb;
}

