/*.......................................................................
 * Returns a dynamically allocated visual info structure for a given
 * visual. This is simply a more convenient interface to XGetVisualInfo()
 * and XVisualIDFromVisual().
 *
 * Input:
 *  display    Display *   The display connection to which the visual
 *                         belongs.
 *  screen         int     The screen to which the visual belongs.
 *  visual      Visual *   The visual for which information is required.
 * Output:
 *  return XVisualInfo *   The required information descriptor, or NULL
 *                         on error.
 */

static XVisualInfo * xw_visual_info ( Display *display, int screen,
                                      Visual *visual ) {
  XVisualInfo *vi=NULL;  /* The return descriptor */
  XVisualInfo template;  /* The search template */
  int nret = 0;          /* The number of descriptors returned */
  /*
   * Using the visual ID and the screen should unambiguously select the
   * information for the specified visual.
   */
  template.visualid = XVisualIDFromVisual(visual);
  template.screen = screen;
  vi = XGetVisualInfo(display, (long)(VisualIDMask | VisualScreenMask),
                      &template, &nret);
  if(vi == NULL || nret < 1) {
    fprintf( stderr,
             "%s: Error getting visual information for visual ID 0x%lx, screen %d.\n",
             XW_IDENT, (unsigned long)template.visualid, screen );
    vi = NULL;
  };
  return vi;
}

