/*.......................................................................
 * Flushes color-representation changes made by xw_set_rgb() to the /xw
 * window. This updates the window colormap. If color index 0 is changed
 * then the background color is also updated.
 *
 * Input:
 *  xw      XWdev *    The MFPLOT /xw device descriptor.
 *  If xw->color.nbuff > 0 {
 *    For(ci=xw->color.sbuff; ci<xw->color.sbuff + xw->color.nbuff; ci++) {
 *      xw->color.pixel[ci] = Color pixel to be changed.
 *      xw->color.xcolor[ci]= Requested color representation.
 *    };
 *  };
 * Output:
 *  If xw->color.nbuff > 0 {
 *    For(ci=xw->color.sbuff; ci<xw->color.sbuff + xw->color.nbuff; ci++) {
 *      xw->color.pixel[ci] = New color pixel if the colormap is readonly.
 *      xw->color.xcolor[ci]= Actual color representation installed.
 *    };
 *  };
 *  return    int      0 - OK.
 *                     1 - Error.
 */
static int xw_update_colors ( XWdev *xw ) {
  int bad_colors = 0;  /* The number of failed color assignments */
  int i;

  /*
   * Device error?
   */
  if(xw->bad_device) return 1;
  /*
   * Are there any colors to be updated?
   */
  if(!xw->color.monochrome && xw->color.nbuff > 0) {
    XColor *xc = &xw->color.xcolor[xw->color.sbuff];
    unsigned long *pixel = &xw->color.pixel[xw->color.sbuff];
    int nbuff = xw->color.nbuff;
    /*
     * Install the colors in the color map.
     */
    switch(xw->color.vi->class) {
    case PseudoColor:
    case GrayScale:
    case DirectColor:
      XStoreColors(xw->display, xw->color.cmap, xc, nbuff);
      break;
    case StaticColor:
    case StaticGray:
    case TrueColor:
      for(i=0; i<nbuff && !xw->bad_device; i++) {
        if(XAllocColor(xw->display, xw->color.cmap, &xc[i])) {
          if(xw->color.initialized)
            XFreeColors(xw->display, xw->color.cmap, &pixel[i], 1, (long)0);
          pixel[i] = xc[i].pixel;
        } else {
          bad_colors++;
        };
      };
      break;
    };
    /*
     * Device error?
     */
    if(xw->bad_device) return 1;
    /*
     * Updates the background color?
     */
    if(xw->color.sbuff == 0)
      XSetWindowBackground(xw->display, xw->window, pixel[0]);
    /*
     * Did any of the color assignments fail?
     */
    if(bad_colors > 0) {
      fprintf( stderr,
               "%s: Error setting the color representations of %d colors.\n",
               XW_IDENT, bad_colors );
    };
  };
  /*
   * Resets buffer pointers.
   */
  xw->color.nbuff = 0;
  xw->color.sbuff = 0;
  return xw->bad_device!=0;
}
