/*.......................................................................
 * Acquire an up to date count of the number of error events generated
 * from all previous Xlib calls since the last time that this function
 * was called. This involves calling XSync() to ensure that all pending
 * requests have been processed, and clears the xw_handle_error() error
 * counter before returning.
 *
 * Thus, to determine whether a given function call causes any errors,
 * bracket it with two calls to xw_sync_error().
 *
 * Input:
 *  xw     XWdev * The MFPLOT device.
 * Output:
 *  return      int   The number of error events.
 */
static int xw_sync_error(XWdev *xw)
{
/*
 * Force queued X requests to the server and wait for them to be processed.
 */
  XSync(xw->display, False);
/*
 * Ask the error handler for the current count of error events and to
 * clear its error counter by sending it a NULL XErrorEvent pointer.
 */
  return xw_handle_error(xw->display, (XErrorEvent *) 0);
}
