/*.......................................................................
 * Shows the pixmap in a new window of appropriate size.
 * (Caution: it works only for pixmap having the same depth as the screen,
 *           or a depth equal to 1, i.e. bitmap)
 *-----------------------------------------------------------------------
 *
 * Input:
 *  xw      XWdev *   The MFPLOT /xw device descriptor.
 *  pixmap  Pixmap    The pixmap to be shown.
 *
 */

static int xw_show_pixmap ( XWdev *xw, Pixmap pixmap, char *name ) {

  Window win, root;
  int x, y;
  unsigned width, height, border, depth, screen_depth;
  unsigned width2, height2;
  unsigned long white_pixel, black_pixel;
  int finished=0;
  char key;
  int i, n;
  char string_tmp[256];

  if ( pixmap == None ) return 1;

  /* Gets width, height and depth of the pixmap */
  XGetGeometry ( xw->display, pixmap, &root, &x, &y,
                 &width, &height, &border, &depth );
  screen_depth = XDefaultDepth ( xw->display, xw->screen );
  if ( depth != screen_depth && depth != 1 ) {
    printf(" xw_show_pixmap: ERROR\n");
    printf("                 Only pixmaps having a depth equal to 1 or that of the screen can be displayed!\n");
    return (1);
  }

  white_pixel = XWhitePixel ( xw->display, xw->screen );
  black_pixel = XBlackPixel ( xw->display, xw->screen );
  /* Avoids a too small window */
  /* TODO: Dans le cas d'une image trop petite, ce serait mieux alors de
   *       mettre un fond avec un pattern de petits carrés gris et blancs
   *       (comme KolourPaint fait pour indiquer la transparence) */
  width2 = MAX(10,width);
  height2 = MAX(10,height);
  win = XCreateSimpleWindow ( xw->display, root,
                              0, 0, width2, height2, 0, black_pixel, white_pixel );

  XSelectInput ( xw->display, win, ExposureMask | KeyPressMask );
  XStoreName ( xw->display, win, name );
  XMapWindow ( xw->display, win );

  printf("  ┌─────────────────────────────────────┐\n");
  printf("  │ Showing a pixmap in a simple window │\n"); /* avail. length=37 */
  sprintf( string_tmp, "        name = \"%s\"", name );
  printf("  │%s",string_tmp);
  n = 37 - strlen(string_tmp);
  for (i=0;i<n;i++) printf(" "); printf("│\n");
  sprintf( string_tmp, "        depth = %d", depth);
  printf("  │%s",string_tmp);
  n = 37 - strlen(string_tmp);
  for (i=0;i<n;i++) printf(" "); printf("│\n");
  printf("  └─────────────────────────────────────┘\n");
  printf("   [Press ESC to close and continue...]\n");
  fflush(stdout);

  while (!finished) {
    XEvent event;
    XNextEvent ( xw->display, &event );
    switch (event.type) {
    case Expose:
      /* not using xw->gc because perhaps it contains some strange attributes */
      if( depth == screen_depth ) {
        XCopyArea ( xw->display, pixmap, win, XDefaultGC(xw->display,xw->screen),
                    0, 0, width, height, 0, 0 );
      } else { /* depth=1 -> bitmap */
        XCopyPlane ( xw->display, pixmap, win, XDefaultGC(xw->display,xw->screen),
                     0, 0, width, height, 0, 0, 1 );
      }
      XFlush ( xw->display );
      break;
    case KeyPress:
    {
      char buffer[10];   /* Buffer to read key definition into */
      KeySym keysym = 0; /* Key code of pressed keyboard key */
      int nret;          /* The number of characters in buffer[] */
      /* Gets the ASCII encoding associated with the key */
      nret = XLookupString ( (XKeyEvent *)&event, buffer,
                             (int) (sizeof(buffer)/sizeof(char)), &keysym, NULL );
      if ( nret == 1 ) {
        key = buffer[0];
        if ( key == 27 ) { /* ESCAPE */
          XDestroyWindow ( xw->display, win );
          XFlush ( xw->display );
          finished = 1;
        }
      }
      break;
    }
    default:
      break;
    }
  }

  return (0);
}
