/*.......................................................................
 * Private function of xw_read_cursor().
 * If the user has just pressed one of the keyboard or keypad arrow keys,
 * it moves the cursor by one pixel in the corresponding direction. If one
 * of the shift keys is also held down, then the cursor is moved by
 * ARROW_KEY_VELOCITY pixels instead of one. If the resulting shift would
 * move the cursor out of the bounds of the pgplot window pixmap, then the
 * motion is aborted.
 *
 * Input:
 *  xw           XWdev *  The MFPLOT /xw device descriptor.
 *  keysym      KeySym    The key symbol returned by XLookupString() wrt
 *                        the arrow-button key-press.
 *  modifiers unsigned    The Event::xkey.state key-modifier mask
 *                        associated with the key-press.
 * Output:
 *  return         int    0 - OK.
 *                        1 - Error.
 */
static int xw_shift_cursor ( XWdev *xw, KeySym keysym,
                             unsigned int modifiers ) {
  Window p_child;         /* The child window that contains the pointer */
  int p_win_x, p_win_y;   /* The pointer coordinates wrt xw->window */
  int p_root_x, p_root_y; /* The pointer coordinates wrt the root window */
  Window p_root_win;      /* The root window that contains the cursor */
  unsigned int p_mask;    /* The bit-mask of button states etc.. */
  int dx=0;               /* The amount to move the cursor in X */
  int dy=0;               /* The amount to move the cursor in Y */
  /*
   * Determines the current position of the cursor.
   */
  XQueryPointer(xw->display, xw->window, &p_root_win, &p_child,
                &p_root_x, &p_root_y, &p_win_x, &p_win_y, &p_mask);
  if(xw->bad_device) return 1;
  /*
   * Works out the position increments in x and y.
   */
  switch(keysym) {
#ifdef XK_KP_Left
  case XK_KP_Left:
#endif
  case XK_Left:
    dx = -1;
    break;
#ifdef XK_KP_Right
  case XK_KP_Right:
#endif
  case XK_Right:
    dx = 1;
    break;
#ifdef XK_KP_Up
  case XK_KP_Up:
#endif
  case XK_Up:
    dy = -1;
    break;
#ifdef XK_KP_Down
  case XK_KP_Down:
#endif
  case XK_Down:
    dy = 1;
    break;
  default:
    return 0;
    break;
  };
  /*
   * If one of the shift keys is held down, increases the size of the
   * move to ARROW_KEY_VELOCITY pixels in the specified direction.
   */
  if(modifiers & ShiftMask) {
    dx *= ARROW_KEY_VELOCITY;
    dy *= ARROW_KEY_VELOCITY;
  };
  /*
   * Determines the final position of the pointer wrt the top left corner
   * of the window.
   */
  p_win_x += dx;
  p_win_y += dy;
  /*
   * Abort the shift operation if the final position lies outside of the
   * bounds of the pgplot window pixmap. Note that this simple test doesn't
   * take account of the fact that another window may lie over the pgplot
   * window, or that the window may have been resized to a smaller size
   * than the pixmap. To do this properly one would have to perform the
   * move, then check for LeaveNotify events and put the cursor back if
   * one was detected. This would be hard to code without breaking
   * xw_read_cursor() which also wants LeaveNotify events, would be
   * slower to operate and would be unavoidably subject to race conditions.
   */
  if(p_win_x < 0 || p_win_x >= xw->geom.width ||
     p_win_y < 0 || p_win_y >= xw->geom.height)
    return 0;
  /*
   * Moves the cursor to the new location.
   */
  XWarpPointer(xw->display, None, xw->window, 0, 0, 0, 0, p_win_x, p_win_y);
  if(xw->bad_device) return 1;
  return 0;
}
