/*.......................................................................
 * Set the focus of a window
 *-----------------------------------------------------------------------
 *
 * Input:
 *  focus: 0 (unset the focus; actually set the focus to the terminal),
 *         1 (set the focus)
 *  xw    XWdev * The MFPLOT /xw device descriptor.
 *
 */

static int xw_set_focus_win ( XWdev *xw, int focus ) {
  XEvent event; /* The latest event */

  /*
   * Device error?
   */
  if(xw->bad_device) return 0;

  XMapWindow ( xw->display, xw->window );
  XSync( xw->display, True );

  /*
   * Waits for a MapNotify event to arrive indicating that the window
   * is now mapped. If not doing so, the most important routine
   * XSetInputFocus() will be ignored...
   *
   * Catch a StructureNotify without blocking.
   */
  xw_add_events ( xw, (long)(StructureNotifyMask) );
  while ( xw_check_window_event( xw, xw->window,
                                 (long)(StructureNotifyMask), &event) ) {
    xw_rem_events ( xw, (long)(StructureNotifyMask) );
  }

  /*
   * Set the focus
   */
  if ( focus ) {
    XSetInputFocus ( xw->display, xw->window, RevertToNone, CurrentTime );
  } else {
    XSetInputFocus ( xw->display, MF_TERMINAL_X11_ID, RevertToNone, CurrentTime );
  }

  XFlush ( xw->display );

  return 1;
}

