/*.......................................................................
 * Instates the given cursor type.
 *
 * Input:
 *  xw      XWdev *   The MFPLOT /xw device descriptor.
 *  shape     int     Corresponding cursor
 *
 * Output:
 *  return    int     0 - OK.
 *                    1 - Error.
 */
static int xw_set_cursor ( XWdev *xw, int shape ) {

  Cursor cursor;  /* The ID of the cursor to be instated */

  /*
   * Device error?
   */
  if(xw->bad_device) return 1;
  /*
   * Gets the cursor ID and color to use.
   */
  switch(shape) {
    case 0:
      cursor = xw->norm_cursor; /* left arrow */
      break;
    case 1:
      cursor = xw->live_cursor; /* crosshair */
      break;
    case 2:
      cursor = xw->resize_cursor; /* resize */
      break;
    case 3:
      cursor = xw->watch_cursor; /* watch */
      break;
    case 4:
      cursor = xw->hand1_cursor; /* opened hand */
      break;
    case 5:
      cursor = xw->hand2_cursor; /* closed hand */
      break;
    case 6:
      cursor = xw->zoom_cursor; /* zoom */
      break;
    case 7:
      cursor = xw->transparent_cursor; /* transp., i.e. no visible cursor */
      break;
    case 8:
      cursor = xw->user1_cursor; /* user1 */
      if ( cursor == None ) {
        printf("MFPLOT: xw_set_cursor: internal error\n");
        printf("        -> user1_cursor not defined!\n");
        return 1;
      }
      break;
    case 9:
      cursor = xw->user2_cursor; /* user2 */
      if ( cursor == None ) {
        printf("MFPLOT: xw_set_cursor: internal error\n");
        printf("        -> user2_cursor not defined!\n");
        return 1;
      }
      break;
    default:
      return 1;
      break;
  }
  /*
   * Registers the cursor to the window.
   */
  XDefineCursor( xw->display, xw->window, cursor );
  if(xw->bad_device) return 1;
  XFlush( xw->display );

  return xw->bad_device!=0;
}

