/*.......................................................................
 * Sets the foreground color.
 *
 * Input:
 *  xw    XWdev *  The MFPLOT /xw device descriptor.
 *  ci      int    The MFPLOT color index to instate as the foreground
 *                 color.
 * Output:
 *  return  int    0 - OK.
 *                 1 - Error.
 */
static int xw_set_ci ( XWdev *xw, int ci ) {
  /*
   * Device error?
   */
  if( xw->bad_device ) return 1;
  /*
   * Assigns white color to out-of-range indexes.
   */
  if( ci < 0 || ci >= xw->color.ncol )
    ci = 1;
  /*
   * Determines the color pixel associated with the given color index.
   */
  if( xw->color.monochrome ) {
    xw->gcv.foreground = ci==1 ? WhitePixel(xw->display, xw->screen) :
                                 BlackPixel(xw->display, xw->screen);
  } else {
    xw->gcv.foreground = xw->color.pixel[ci];
  };
  /*
   * Instates the new foreground color.
   */
  XSetForeground( xw->display, xw->gc, xw->gcv.foreground );
  if( xw->bad_device ) return 1;
  return 0;
}

