/*.......................................................................
 * Selects a given device by its MFPLOT window number: xw->number.
 *
 * Input:
 *  number      int   The device number to search for.
 * Output:
 *  return    XWdev * The descriptor of the located device, or NULL
 *                    on error.
 */

static XWdev * xw_select_device ( int number ) {
  /*
   * Search for the cited device.
   */
  XWdev *xw = device_list;
  while(xw && xw->number != number)
    xw = xw->next;
  if(xw==NULL || xw->number!=number) {
    fprintf( stderr, "%s: No such device (%d).\n", XW_IDENT, number );
    return NULL;
  };
  return xw;
}

