/*.......................................................................
 * Moves the first auxiliary pixmap in the main pixmap.
 *
 * Input:
 *  xw     XWdev *  The MFPLOT window context.
 */

static void xw_scroll_rect ( XWdev *xw, int Dx, int Dy,
                             int VP_width, int VP_height,
                             int *pos_xy, int *ret_dx, int *ret_dy,
                             int xmin2, int ymin2, int width2, int height2,
                             int axis_on ) {

  int dx, dy, dx_test, dy_test;
  XPoint pos, pos_init, pos_ref;

  /* Attention, pos_xy est très légèrement différent de TLC
   * (le dernier correspond au clipping, corrigé d'un shift de 1 pixel
   *  pour ne pas écrire sur le cadre des axes) */
  int pos_x = pos_xy[0], pos_y = pos_xy[1];

  /* Small fix */
  VP_width  = VP_width  + 1;
  VP_height = VP_height + 1;

  /*
   * Device error?
   */
  if ( xw->bad_device ) return;

  if ( xw->pixmap_aux_1 == None ) return;

  /* Registers initial pointer position */
  xw_current_pos(xw, &pos_init);

  pos_ref = pos_init;

  CALL_MF_PGSCH_FROM_X11_DRIVER( );

  while(1) {
    /* Get current pointer position */
    if ( xw_current_pos(xw, &pos) == 1 ) { /* inside the window */
      /* Moves the image if there is at least one pixel of difference,
       * and only if the pointer is inside the window */
      dx = pos.x - pos_init.x;
      dy = pos.y - pos_init.y;
      dx_test = pos.x - pos_ref.x;
      dy_test = pos.y - pos_ref.y;
      if ( abs(dx_test)>0 || abs(dy_test)>0 ) {

        /* Copies image at the new position */
        XCopyArea ( xw->display, xw->pixmap_aux_1, xw->pixmap, xw->gc,
                    Dx-dx, Dy-dy, VP_width, VP_height, pos_x, pos_y );
        xw_mark_modified ( xw, pos_x, pos_y, 1 );
        xw_mark_modified ( xw, pos_x+VP_width, pos_y+VP_height, 1 );

        /* Move also the axes */
        CALL_MF_PGTBOX_FROM_X11_DRIVER( &dx, &dy, &axis_on );

        /* If needed, copies also the foreground portion */
        if( xw->pixmap_aux_2 != None ) {
          XCopyArea ( xw->display, xw->pixmap_aux_2, xw->pixmap, xw->gc2,
                      0, 0, width2, height2, xmin2, ymin2 );
          xw_mark_modified ( xw, xmin2, ymin2, 1 );
          xw_mark_modified ( xw, xmin2+width2, ymin2+height2, 1 );
        }

        /* Flushes XW buffer because we want a continuously updated window */
        xw_flush ( xw );
      }
      if ( xw_get_click(xw) == 1 ) {
        /* got a click (actually mouse up) */
        break;
      }
      pos_ref = pos;
    }
  }

  *ret_dx = dx;
  *ret_dy = dy;

  return;
}

