/*.......................................................................
 * Maps floating point color intensities between 0.0 and 1.0 to XColor
 * intensities between 0 to COLORMULT. Numbers outside of this range are
 * limited to the nearest of the two limits.
 *
 * Input:
 *  rgb             double  The MFPLOT normalized intensity to be converted.
 * Output:
 *  return  unsigned short  The equivalent XColor RGB intensity.
 */
static int xw_rgb_to_xcolor ( double rgb ) {
  long lrgb;
  /*
   * Check for limiting input values.
   */
  if( rgb < 0.0 ) return 0;
  if( rgb > 1.0 ) return COLORMULT;
  /*
   * Form the Xcolor intensity in a long int so that its range can be
   * checked before casting to int.
   */
  lrgb = xw_nint( rgb*COLORMULT );
  return lrgb > COLORMULT ? COLORMULT : lrgb;
}

