/*.......................................................................
 * Removes a given MFPLOT /xw device descriptor from the list of open
 * devices.
 *
 * Input:
 *  xw      XWdev *  The MFPLOT /xw device descriptor to be removed.
 * Output:
 *  return  XWdev *  The removed descriptor.
 */

static XWdev * xw_remove_device ( XWdev *xw ) {
  XWdev *prev;   /* Pointer to previous device in list */
  XWdev *next;   /* Pointer to next device in list */
  /*
   * Finds the position of the device in the device list.
   */
  prev = NULL;
  next = device_list;
  while(next && next!=xw) {
    prev = next;
    next = next->next;
  };
  /*
   * Relinks around the window if it was found.
   */
  if(next) {
    if(prev==NULL)
      device_list = next->next;
    else
      prev->next = next->next;
  };
  /*
   * The descriptor is no longer in a list.
   */
  xw->next = NULL;
  return xw;
}

