/*.......................................................................
 * Removes selected events from the set of events to be caught.
 *
 * Input:
 *  xw    XWdev *  The MFPLOT /xw device descriptor.
 *  events long    The bit mask of events to be removed from the set
 *                 being selected.
 * Output:
 *  return  int    0 - OK.
 *                 1 - Error.
 */
static int xw_rem_events ( XWdev *xw, long events ) {
  /*
   * Device error?
   */
  if(xw->bad_device) return 1;
  /*
   * Clears the bits in our current event mask that correspond to the events
   * to be removed.
   */
  xw->event.mask &= ~events;
  /*
   * Registers the modified selection with the server.
   */
  XSelectInput(xw->display, xw->window, xw->event.mask);
  if(xw->bad_device) return 1;
  XSync(xw->display, False);
  if(xw->bad_device) return 1;
  return 0;
}

