/*.......................................................................
 * Check a key pressed, without waiting.
 *
 * Input:
 *  xw    XWdev *   The MFPLOT /xw device descriptor.
 *
 * Output:
 *  key   char *  If key!=NULL, the selection key will be assigned to
 *                the caller's variable pointed to by key.
 *  return int    0 - OK.
 *                1 - Error.
 */

static int xw_read_cursor_no_wait ( XWdev *xw, char *key ) {
  XEvent event;           /* The latest event */

  /*
   * Device error?
   */
  if( xw->bad_device ) return 1;
  /*
   * Makes sure that the window is up to date.
   */
  if( xw_flush(xw) ) return xw_end_cursor(xw, NULL, 1);
  /*
   * De-iconifies and brings the window to the foreground.
   */
  XMapRaised( xw->display, xw->window );
  if( xw->bad_device ) return xw_end_cursor(xw, NULL, 1);
  XSync( xw->display, False );
  if( xw->bad_device ) return xw_end_cursor(xw, NULL, 1);
  /*
   * (from xw_read_cursor)
   */
  {
    long event_mask = ExposureMask | KeyPressMask | KeyReleaseMask;
    xw_add_events(xw, event_mask);
  }

  if( xw->bad_device ) return xw_end_cursor(xw, NULL, 1);

  /*
   * Handles the next selected event.
   */

  /* Check that the next event exists, else it will be blocked!
   * (XPending returns the number of events in the queue)
   */
  if( XPending(xw->display) == 0 ) return xw_end_cursor(xw, NULL, 1);
  if( xw_next_event(xw, &event) ) return xw_end_cursor(xw, NULL, 1);

  switch(event.type) {

    case KeyPress:
      {
        char buffer[10];   /* Buffer to read key definition into */
        KeySym keysym = 0; /* Key code of pressed keyboard key */
        int nret;          /* The number of characters in buffer[] */
        /*
         * Gets the ASCII encoding associated with the key.
         */
        nret = XLookupString((XKeyEvent *)&event, buffer,
                   (int) (sizeof(buffer)/sizeof(char)), &keysym, NULL);

        if(xw->bad_device) return xw_end_cursor(xw, NULL, 1);
        /*
         * Detects the Ctrl key down.
         */
        if( keysym == XK_Control_L || keysym == XK_Control_R ) CTRL_KEY_DOWN = 1;
        /*
         * Ignores modifier keys and all but single character keys.
         */
        if(nret==1 && (keysym < XK_Shift_L || keysym > XK_Hyper_R)) {
          if(key) *key = buffer[0];

          /* modif E.C. */
          if(*key == 27) { /* ESCAPE */
            CTRL_KEY_DOWN = 0;
            xw_set_cursor(xw,XW_LEFT_ARROW_CURSOR);
            break;
          }

        };
      };
      break;

    default:
      break;

    };

  /*
   * Clean up.
   */
  return xw_end_cursor(xw, NULL, xw->bad_device!=0);
}

