/*.......................................................................
 * Before using a given /xw device descriptor call this function to check
 * that it is usable. If it isn't, 0 will be returned and you should not
 * attempt to use the descriptor. If the descriptor is NULL an error
 * message will be presented.
 *
 * Input:
 *  xw       XWdev *  The device descriptor to be checked.
 * Output:
 *  return     int    1 - Descriptor OK.
 *                    0 - Error - don't use /xw.
 */
static int xw_ok ( XWdev *xw ) {
  if(xw==NULL) {
    fprintf( stderr, "%s: Device not open.\n", XW_IDENT );
    return 0;
  };
  /*
   * If the window is marked as unusable, it must have been set that way
   * after an error was detected. Assume that the error must already
   * have been reported.
   */
  if(xw->bad_device) return 0;
  return 1;
}

