/*.......................................................................
 * Starts a new page by clearing and possibly re-sizing the given /xw
 * window and its pixmap. If the current size of the window is equal
 * to the requested new size, then only the window clearing operation
 * will be performed.
 *
 * Input:
 *  xw        XWdev * The MFPLOT /xw device descriptor of the window to be
 *                    resized.
 *  width  unsigned   The new width for the re-sized window (pixels).
 *  height unsigned   The new height for the re-sized window (pixels).
 * Output:
 *  return  int       0 - OK.
 *                    1 - Error.
 */
static int xw_next_page ( XWdev *xw, unsigned int width, unsigned int height ) {

   int need_resize;  /* True if the current pixmap size needs to be changed */
  /*
   * Device error?
   */
  if( xw->bad_device ) return 1;

  /*
   * Does the pixmap need to be resized?
   */
  need_resize = width != xw->geom.width || height != xw->geom.height;

  /*
   * Establishes the new geometry.
   */
  if( xw_new_geom( xw, 0, 0, width, height ) ) return 1;
  /*
   * Resets the colormap color representations if necessary.
   */
  if(!xw->color.initialized && xw_init_colors(xw)) return 1;
  /*
   * Allocates a new pixmap?
   */
  if( xw->pixmap == None || need_resize ) {
    xw_get_pixmap( xw );
    if( xw->bad_device ) return 1;
    pixmap_ID = xw->pixmap;
    /*
     * If a new pixmap is not required, simply clears the window and pixmap.
     */
  } else {
    if( xw_clear(xw) ) return 1;
  };
  return 0;
}

