/*.......................................................................
 * Front end to XNextEvent() to get the next event from the X server,
 * while checking for DestroyNotify events on the MFPLOT window.
 *
 * Input:
 *  xw      XWdev *  The MFPLOT /xw device descriptor.
 * Input/Output:
 *  event  XEvent *  The event structure for the returned event.
 * Output:
 *  return    int    0 - OK.
 *                   1 - The MFPLOT window has been destroyed.
 */
static int xw_next_event ( XWdev *xw, XEvent *event ) {
  /*
   * Checks that we still have a window.
   */
  if(xw->bad_device) return 1;
  /*
   * Waits for the next event.
   */
  XNextEvent(xw->display, event);
  switch(event->type) {
  case DestroyNotify:
    if(event->xdestroywindow.window == xw->window)
      return xw_bad_device(xw);
  };
  return 0;
}
