/*.......................................................................
 * Create new cursors for use by the device.
 *
 *  xw    XWDev * The MFPLOT device
 *
 * Output:
 *  return     int   0 - OK.
 *                   1 - Error.
 */
static int xw_new_cursors( XWdev *xw ) {

  Pixmap resize_mask, resize,
         watch_mask, watch,
         openhand_mask, openhand,
         closedhand_mask, closedhand,
         zoom_mask, zoom,
         transparent_mask, transparent;
  Colormap cmap;
  XColor black, white, exact;

  /*
   * Create the new cursors.
   *   from Xlib
   */
  cmap = DefaultColormap(xw->display, xw->screen);
  XAllocNamedColor(xw->display, cmap, "black", &black, &exact);
  XAllocNamedColor(xw->display, cmap, "white", &white, &exact);

  xw->norm_cursor = XCreateFontCursor(xw->display, XC_left_ptr);
  if( xw->norm_cursor == None ) {
    fprintf(stderr, "MFPLOT: Error creating cursor 'norm'.\n");
    return 1;
  };

  xw->live_cursor = XCreateFontCursor(xw->display, XC_crosshair);
  if( xw->live_cursor == None ) {
    fprintf(stderr, "MFPLOT: Error creating cursor 'live'.\n");
    return 1;
  };

  /* from bitmap */

  resize_mask = XCreateBitmapFromData(xw->display, xw->window, resize_mask_bits,
                                      resize_mask_width, resize_mask_height);
  resize = XCreateBitmapFromData(xw->display, xw->window, resize_bits,
                                 resize_width, resize_height);
  xw->resize_cursor = XCreatePixmapCursor(xw->display, resize, resize_mask, &black, &white,
                                          resize_x_hot, resize_y_hot);
  if( xw->resize_cursor == None ) {
    fprintf(stderr, "MFPLOT: Error creating cursor 'resize'.\n");
    return 1;
  };

  watch_mask = XCreateBitmapFromData(xw->display, xw->window, watch_mask_bits,
                                     watch_mask_width, watch_mask_height);
  watch = XCreateBitmapFromData(xw->display, xw->window, watch_bits,
                                watch_width, watch_height);
  xw->watch_cursor = XCreatePixmapCursor(xw->display, watch, watch_mask, &black, &white,
                                         watch_x_hot, watch_y_hot);
  if( xw->watch_cursor == None ) {
    fprintf(stderr, "MFPLOT: Error creating cursor 'watch'.\n");
    return 1;
  };

  openhand_mask = XCreateBitmapFromData(xw->display, xw->window, openhand_mask_bits,
                                        openhand_mask_width, openhand_mask_height);
  openhand = XCreateBitmapFromData(xw->display, xw->window, openhand_bits,
                                   openhand_width, openhand_height);
  xw->hand1_cursor = XCreatePixmapCursor(xw->display, openhand, openhand_mask, &black, &white,
                                         openhand_x_hot, openhand_y_hot);
  if( xw->hand1_cursor == None ) {
    fprintf(stderr, "MFPLOT: Error creating cursor 'openhand'.\n");
    return 1;
  };

  closedhand_mask = XCreateBitmapFromData(xw->display, xw->window, closedhand_mask_bits,
                                          closedhand_mask_width, closedhand_mask_height);
  closedhand = XCreateBitmapFromData(xw->display, xw->window, closedhand_bits,
                                     closedhand_width, closedhand_height);
  xw->hand2_cursor = XCreatePixmapCursor(xw->display, closedhand, closedhand_mask, &black, &white,
                                         closedhand_x_hot, closedhand_y_hot);
  if( xw->hand2_cursor == None ) {
    fprintf(stderr, "MFPLOT: Error creating cursor 'closedhand'.\n");
    return 1;
  };

  zoom_mask = XCreateBitmapFromData(xw->display, xw->window, zoom_mask_bits,
                                    zoom_mask_width, zoom_mask_height);
  zoom = XCreateBitmapFromData(xw->display, xw->window, zoom_bits,
                               zoom_width, zoom_height);
  xw->zoom_cursor = XCreatePixmapCursor(xw->display, zoom, zoom_mask, &black, &white,
                                        zoom_x_hot, zoom_y_hot);
  if( xw->zoom_cursor == None ) {
    fprintf(stderr, "MFPLOT: Error creating cursor 'zoom'.\n");
    return 1;
  };

  transparent_mask = XCreateBitmapFromData(xw->display, xw->window, transparent_mask_bits,
                                          transparent_mask_width, transparent_mask_height);
  transparent = XCreateBitmapFromData(xw->display, xw->window, transparent_bits,
                                      transparent_width, transparent_height);
  xw->transparent_cursor = XCreatePixmapCursor(xw->display, transparent, transparent_mask, &black, &white,
                                               transparent_x_hot, transparent_y_hot);
  if( xw->transparent_cursor == None ) {
    fprintf(stderr, "MFPLOT: Error creating cursor 'transparent'.\n");
    return 1;
  };

  return 0;
}

