/*.......................................................................
 * Set up for a band cursor and return its descriptor.
 *
 * Input:
 *  xw    XWdev *   The MFPLOT /xw device descriptor.
 *  mode    int     0 - No band cursor.
 *                  1 - Line between reference position and cursor.
 *                  2 - Rectangle drawn with opposite corners at reference
 *                      and cursor position.
 *                  3..8 - see xw_draw_cursor()
 *  ref  XPoint *   The reference position.
 * Output:
 *  return Band *   A pointer to a static internal container of cursor
 *                  resources. Call xw_del_Band() to release these resources
 *                  and return the event mask to normal.
 */
static Band * xw_new_Band ( XWdev *xw, int mode, XPoint *ref ) {
  static Band band;        /* Return container */
  long event_mask = 0;     /* mask of events to be caught */
  /*
   * Device error?
   */
  if(xw->bad_device) return NULL;
  /*
   * Initializes values at least to the point at which xw_del_Band() can
   * safely be called.
   */
  band.line_width = xw->gcv.line_width;
  band.mode = mode;

  if( mode == 101 ) {
    band.gc = XCreateGC ( xw->display, xw->window, 0, NULL );
    XSetForeground( xw->display, band.gc, PIX_USER1_COLOR.pixel );
    XSetBackground( xw->display, band.gc, 0xFFFFFF ); /* white */
    XSetClipMask ( xw->display, band.gc, PIX_USER1_CURSOR_MASK );
  }

  band.ref = *ref;
  band.end = *ref;
  if( mode == 8 ) {
    band.width = ref->x;
    band.height = ref->y;
    band.xmin = VP_TLC.x;
    band.ymin = VP_TLC.y;
    band.xmax = VP_BRC.x;
    band.ymax = VP_BRC.y;
    band.inside = rect_inside;
  }

  /*
   * All cursor types require us to catch the following events.
   * Warning: doit correspondre au masque utilisé dans 'xw_check_window_event'
   * de la routine 'xw_read_cursor'
   */
  event_mask = ExposureMask | KeyPressMask | KeyReleaseMask |
               ButtonPressMask | ButtonReleaseMask |
               EnterWindowMask | PointerMotionMask |
               LeaveWindowMask;
  /*
   * Set up for a band cursor?
   */
  if(band.mode != 0 || xw->crosshair) {
    /*
     * Arranges for the band cursor to be drawn with a line width of 0.
     */
    if(band.line_width != 0) {
      XGCValues attr;
      band.line_width = attr.line_width = 0;
      XChangeGC(xw->display, xw->gc, (unsigned long) GCLineWidth, &attr);
      if(xw->bad_device) return NULL;
    };
    /*
     * Selects for cursor motion events along with the normal events.
     */
    event_mask |= PointerMotionMask;
  };
  /*
   * Registers the additional event types that are now to be caught.
   */
  if(xw_add_events(xw, event_mask)) return NULL;

  return &band;
}

