/*
 * See opcode 82
 * Uses the 2nd GC, which never have a ClipMask.
 */

static void xw_move_grobj ( XWdev *xw, int *ret_x, int *ret_y ) {

  int xmin, ymin, xmax, ymax, empty;
  int xmin2, ymin2, xmax2, ymax2, empty2;
  int width, height, width2, height2;
  XPoint TL, TL2;
  Window root;
  Pixmap pixmap_tmp;

  /* Finds the bbox of the moving image */
  xw_bbox_of_pixmap ( xw, xw->pixmap_aux_1,
                      &xmin, &ymin, &xmax, &ymax, &empty );

  if( xw->pixmap_aux_2 != None ) {
    /* Finds the bbox of the foreground part */
    xw_bbox_of_pixmap ( xw, xw->pixmap_aux_2,
                        &xmin2, &ymin2, &xmax2, &ymax2, &empty2 );
  }

  if( empty ) {

    printf ( "(X11 driver:) xw_move_grobj: pixmap_aux_1 is empty!\n");
printf("   [Press RETURN to continue...]\n");
fflush(stdout);
getchar();
    *ret_x = 0; /* shift is set to zero in case of error */
    *ret_y = 0; /* (also, avoid an 'unitialized value' warning from valgrind */

    if( xw->pixmap_aux_2 != None ) {
printf("(X11 driver:) xw_move_grobj: not ready (must use transparency!)\n");
printf("   [Press RETURN to continue...]\n");
fflush(stdout);
getchar();
/*      XCopyArea ( xw->display, xw->pixmap_aux_2, xw->pixmap, xw->gc,
                  xmin, ymin, width, height, 0, 0 ); */
    }

  } else {

    width  = xmax - xmin + 1;
    height = ymax - ymin + 1;

    /* Copies pixmap_aux_1 in a smaller pixmap TODO: always? */
    root = RootWindow ( xw->display, DefaultScreen(xw->display) );
    pixmap_tmp = XCreatePixmap ( xw->display, root, width, height,
                                 (unsigned) xw->color.vi->depth );
    XCopyArea ( xw->display, xw->pixmap_aux_1, pixmap_tmp, xw->gc2,
                xmin, ymin, width, height, 0, 0 );
    XFreePixmap( xw->display, xw->pixmap_aux_1 );

    /* Copies just the drawable ID (avoid a true copy) */
    xw->pixmap_aux_1 = pixmap_tmp;

    /* If an XftDraw surface was attached to this aux pixmap, update it */
    if( xw->xftdraw_pixmap_aux_1 ) {
      XftDrawChange ( xw->xftdraw_pixmap_aux_1, xw->pixmap_aux_1 );
    }

    if( xw->pixmap_aux_2 != None ) {
      width2  = xmax2 - xmin2 + 1;
      height2 = ymax2 - ymin2 + 1;
      /* Copies pixmap_aux_2 in a smaller pixmap TODO: always? */
      pixmap_tmp = XCreatePixmap ( xw->display, root, width2, height2,
                                   (unsigned) xw->color.vi->depth );
      XCopyArea ( xw->display, xw->pixmap_aux_2, pixmap_tmp, xw->gc2,
                  xmin2, ymin2, width2, height2, 0, 0 );
      XFreePixmap( xw->display, xw->pixmap_aux_2 );

      /* Copies just the drawable ID (avoid a true copy) */
      xw->pixmap_aux_2 = pixmap_tmp;

      /* If an XftDraw surface was attached to this aux pixmap, update it */
      if( xw->xftdraw_pixmap_aux_2 ) {
        XftDrawChange ( xw->xftdraw_pixmap_aux_2, xw->pixmap_aux_2 );
      }

      TL2.x = xmin2;
      TL2.y = ymin2;
    }

    TL.x = xmin;
    TL.y = ymin;
    xw_move_rect_in_pixmap ( xw, &TL, &TL2 );
    *ret_x =   TL.x-xmin ;
    *ret_y = -(TL.y-ymin);
  }

}

