/*.......................................................................
 * Moves an arrow interactively in the window
 *  1 - draw the arrow at its initial position, defined by the global
 *      variable ARROW_START and ARROW_END (type XPoint).
 *  2 - using the mouse, you can move it interactively inside the window,
 *      until the ESC key is pressed.
 *
 * During the move, it uses a local pixmap ('pixmap_save') to restore the
 * drawing after each move (it has been saved by the calling routine:
 * 'xw_move_arrow').
 * If available, another pixmap (pixmap_aux_2, which contains the foreground
 * drawing) is continuously drawn over the main pixmap, after the image,
 * using also white as a transparent color.
 * The arrow may be clipped at the viewport: it uses CLIPPED_OBJ, which has
 * not the same meaning as CLIPPING.
 * Also, uses the 2nd GC, which never have a ClipMask.
 *-----------------------------------------------------------------------
 *
 * Input:
 *  xw     XWdev *     The MFPLOT /xw device descriptor.
 *  Pixmap pixmap_save The saved image of the background.
 *
 */

static void xw_move_arrow_in_pixmap ( XWdev *xw, Pixmap pixmap_save ) {

  /* Number of hotspots (3 for an arrow) */
  int nbspot = 3;

  /* Radius of the animated circle at each hotspot (must match that of
   * 'xw_animate_dashed_multispot') */
  int radius = 8;

  /* Hotspots location (X11 coords) */
  int ispot[3], jspot[3];

  /* Top-left corner and size of the arrow bounding box */
  int Arrow_BBox_x, Arrow_BBox_y, Arrow_BBox_w, Arrow_BBox_h;

  /* variable declaration for the foreground drawing */
  Window root;
  Pixmap clipMask2, pixmap_tmp;
  int xmin2, ymin2, xmax2, ymax2, empty2;
  unsigned int width2, height2;
  XPoint TL2;
  GC gc2;

  struct my_struct_arg *arg;

// ### mettre le clipping (sur le GC gc ?) ... il semble pourtant y être déjà !

  if( xw->pixmap_aux_2 != None ) {

    root = RootWindow ( xw->display, DefaultScreen(xw->display) );
    /* Finds the bbox of the foreground part */
    xw_bbox_of_pixmap ( xw, xw->pixmap_aux_2,
                        &xmin2, &ymin2, &xmax2, &ymax2, &empty2 );
    width2  = xmax2 - xmin2 + 1;
    height2 = ymax2 - ymin2 + 1;
    /* Copies pixmap_aux_2 in a smaller pixmap TODO: always? */
    pixmap_tmp = XCreatePixmap ( xw->display, root, width2, height2,
                                 (unsigned) xw->color.vi->depth );
    XCopyArea ( xw->display, xw->pixmap_aux_2, pixmap_tmp, xw->gc2,
                xmin2, ymin2, width2, height2, 0, 0 );
    XFreePixmap( xw->display, xw->pixmap_aux_2 );
    /* Copies just the drawable ID (avoid a true copy) */
    xw->pixmap_aux_2 = pixmap_tmp;
    /* If an XftDraw surface was attached to this aux pixmap, update it */
    if( xw->xftdraw_pixmap_aux_2 ) {
      XftDrawChange ( xw->xftdraw_pixmap_aux_2, xw->pixmap_aux_2 );
    }
    TL2.x = xmin2;
    TL2.y = ymin2;

    clipMask2 = xw_bitmap_from_pixmap ( xw, xw->pixmap_aux_2 );
    gc2 = XCreateGC ( xw->display, xw->pixmap, 0, NULL ); /* 0 -> use defaults */
    XSetClipMask ( xw->display, gc2, clipMask2 );
    XSetClipOrigin ( xw->display, gc2, TL2.x, TL2.y );

    XCopyArea ( xw->display, xw->pixmap_aux_2, xw->pixmap, gc2,
                0, 0, width2, height2, TL2.x, TL2.y );
    xw_mark_modified ( xw, TL2.x, TL2.y, 1 );
    xw_mark_modified ( xw, TL2.x+width2, TL2.y+height2, 1 );
  }

  xw_flush ( xw );

  arg = malloc(sizeof(struct my_struct_arg));
  arg->xw = xw;

  pthread_create ( &ADC_thread, NULL, xw_animate_dashed_multispot, arg );

  while(1) {
    char key;
    int selectedSpot;
    XPoint pos, pos_ref;
    int dx, dy; // shifted pixels

    /* Position of the three spots (base-middle-end) */
    /* Arrow base */
    ispot[0] = ARROW_START.x;
    jspot[0] = ARROW_START.y;
    /* Arrow head */
    ispot[2] = ARROW_END.x;
    jspot[2] = ARROW_END.y;
    /* Arrow middle */
    ispot[1] = (ispot[0]+ispot[2])/2;
    jspot[1] = (jspot[0]+jspot[2])/2;

    /* Compute the BBox of the arrow (augmented by the hotspots radius!) */
    Arrow_BBox_x = MIN( ARROW_START.x, ARROW_END.x ) - radius;
    Arrow_BBox_y = MIN( ARROW_START.y, ARROW_END.y ) - radius;
    Arrow_BBox_w = abs( ARROW_START.x - ARROW_END.x ) + 2*radius;
    Arrow_BBox_h = abs( ARROW_START.y - ARROW_END.y ) + 2*radius;

    /* waiting for a click (mouse down) or a key pressed... */
    if( xw_read_cursor_dyn_multispot( xw, ispot,jspot,nbspot, XW_OPENED_HAND_CURSOR,
                                      &selectedSpot, &pos, &key )==0 ) {
    } else {
      key = '\0';
    }

    if(key == 27) { /* ESCAPE */
      ADC_finished = 1;
      pthread_join ( ADC_thread, NULL );
      break;
    } else if(key == 'L') { /* left button click (down) */
      xw_set_cursor(xw,XW_CLOSED_HAND_CURSOR);
      /* Registers current pointer position */
      xw_current_pos(xw, &pos_ref);
      while(1) {
        /* Get position */
        if ( xw_current_pos(xw, &pos) == 1 ) { /* inside the window */
          /* Moves the image if there is at least one pixel of difference,
           * and only if the pointer is inside the window */
          dx = pos.x - pos_ref.x;
          dy = pos.y - pos_ref.y;
          if ( abs(dx)>0 || abs(dy)>0 ) {

            /* Restores pixmap_save -- difficult to optimize because the
             * background color is transparent.
             * Small extension of 'radius' pixels around the grobj, in
             * order to be sure to cover the additional animated contour */
            XCopyArea ( xw->display, pixmap_save, xw->pixmap, xw->gc2,
                        Arrow_BBox_x, Arrow_BBox_y,
                        Arrow_BBox_w, Arrow_BBox_h,
                        Arrow_BBox_x, Arrow_BBox_y );
            xw_mark_modified ( xw, Arrow_BBox_x, Arrow_BBox_y, 1 );
            xw_mark_modified ( xw, Arrow_BBox_x+Arrow_BBox_w, Arrow_BBox_y+Arrow_BBox_h, 1 );

            /* Update the arrow location */
            switch (selectedSpot) {
              case 1:
                ARROW_START.x += dx;
                ARROW_START.y += dy;
                break;
              case 2:
                ARROW_START.x += dx;
                ARROW_START.y += dy;
                ARROW_END.x += dx;
                ARROW_END.y += dy;
                break;
              case 3:
                ARROW_END.x += dx;
                ARROW_END.y += dy;
                break;
              default:
                printf("\n(FGL Muesli:) internal error\n");
                printf("                xw_move_arrow_in_pixmap: bad selectedSpot!\n");
            }

            /* Update position of the three spots (base-middle-end) */
            /* Arrow base */
            ispot[0] = ARROW_START.x;
            jspot[0] = ARROW_START.y;
            /* Arrow head */
            ispot[2] = ARROW_END.x;
            jspot[2] = ARROW_END.y;
            /* Arrow middle */
            ispot[1] = (ispot[0]+ispot[2])/2;
            jspot[1] = (jspot[0]+jspot[2])/2;

            /* Update BBox of the arrow */
            Arrow_BBox_x = MIN( ARROW_START.x, ARROW_END.x ) - radius;
            Arrow_BBox_y = MIN( ARROW_START.y, ARROW_END.y ) - radius;
            Arrow_BBox_w = abs( ARROW_START.x - ARROW_END.x ) + 2*radius;
            Arrow_BBox_h = abs( ARROW_START.y - ARROW_END.y ) + 2*radius;

            /* Draw the arrow in the main pixmap */
            xw_draw_arrow( xw );

            /* If needed, copies also the foreground portion */
            if( xw->pixmap_aux_2 != None ) {
              XCopyArea ( xw->display, xw->pixmap_aux_2, xw->pixmap, gc2,
                          0, 0, width2, height2, TL2.x, TL2.y );
              xw_mark_modified ( xw, TL2.x, TL2.y, 1 );
              xw_mark_modified ( xw, TL2.x+width2, TL2.y+height2, 1 );
            }

            /* Flushes XW buffer because we want a continuously updated window */
            xw_flush ( xw );

            pos_ref = pos;
          }
          if ( xw_get_click(xw) == 1 ) {
             /* got a click (actually mouse up) */
             break;
          }
        }
      }

    }
  }
  if( xw->pixmap_aux_2 != None ) {
    XFreeGC( xw->display, gc2 );
  }

}

