/*.......................................................................
 * Updates the vertices of the rectangular area that has been modified
 * since the last time the window was updated from the pixmap.
 *
 * Input:
 *  xw      XWdev * The MFPLOT /xw device descriptor.
 *  x         int   The x-axis pixel index that the rectangular update area
 *                  must be extended to include.
 *  y         int   The y-axis pixel index that the rectangular update area
 *                  must be extended to include.
 *  diameter  int   The diameter of the locus in pixels. For line or
 *                  point drawing operations this is usually the line width.
 */
static void xw_mark_modified ( XWdev *xw, int x, int y, int diameter ) {
  int radius = diameter/2;
  /*
   * Extends the current rectangle to include point (x,y).
   */
  if(xw->update.modified) {
    if(x - radius < xw->update.xmin)
      xw->update.xmin = x - radius;
    if(x + radius > xw->update.xmax)
      xw->update.xmax = x + radius;
    if(y - radius < xw->update.ymin)
      xw->update.ymin = y - radius;
    if(y + radius > xw->update.ymax)
      xw->update.ymax = y + radius;
  } else {
    xw->update.xmin = x - radius;
    xw->update.xmax = x + radius;
    xw->update.ymin = y - radius;
    xw->update.ymax = y + radius;
    xw->update.modified = 1;
  };
  return;
}

