/*.......................................................................
 * Limits pixmap coordinates to lie within the pixmap area.
 *
 * Input:
 *  xw      XWdev *  The MFPLOT window context.
 * Input/Output:
 *  coord  XPoint *  The coordinates to be modified.
 */

static void xw_limit_pcoords ( XWdev *xw, XPoint *coord ) {
  if(xw->pixmap != None) {
    if(coord->x >= xw->geom.width)
      coord->x = xw->geom.width - 1;
    if(coord->y >= xw->geom.height)
      coord->y = xw->geom.height - 1;
    if(coord->x < 0)
      coord->x = 0;
    if(coord->y < 0)
      coord->y = 0;
  };
  return;
}

