/*.......................................................................
 * Tests if a given point (xt,yt) is inside a convex quadrilateral shape,
 * given by its vertices A, B, C and D, and assuming that this order is
 * counterclockwise.
 * The coordinates of its vertices (A,B,C,D) are stored in the array
 * xb[0..3] and yb[0..3].
 *
 * The function returns 0 if the test point is outside the shape,
 * and 1 if it is inside.
 *
 * Algorithm: the four dot-products TAxTB, TBxTC, TCxTD, TDxTA must be
 * all positive.
 */

static int xw_is_inside_quad ( int xb[], int yb[], int *xt, int *yt ) {

   /* Dot product TAxTB */
   if( (xb[0]-*xt)*(yb[1]-*yt) - (yb[0]-*yt)*(xb[1]-*xt) < 0 ) return 0;

   /* Dot product TBxTC */
   if( (xb[1]-*xt)*(yb[2]-*yt) - (yb[1]-*yt)*(xb[2]-*xt) < 0 ) return 0;

   /* Dot product TCxTD */
   if( (xb[2]-*xt)*(yb[3]-*yt) - (yb[2]-*yt)*(xb[3]-*xt) < 0 ) return 0;

   /* Dot product TDxTA */
   if( (xb[3]-*xt)*(yb[0]-*yt) - (yb[3]-*yt)*(xb[0]-*xt) < 0 ) return 0;

   return 1;

}

