/*.......................................................................
 * Inserts a new MFPLOT /xw device descriptor onto the list of open
 * devices. The descriptor is inserted such that the list is maintained
 * in order of window number xw->number.
 *
 * Input:
 *  xw      XWdev *  The MFPLOT /xw device descriptor to be inserted.
 * Output:
 *  return  XWdev *  The same as the input.
 */
static XWdev * xw_insert_device ( XWdev *xw ) {
  XWdev *prev;   /* Pointer to previous device in list */
  XWdev *next;   /* Pointer to next device in list */
  /*
   * Finds the correct position for the device in the device list.
   */
  prev = NULL;
  next = device_list;
  while(next && next->number > xw->number) {
    prev = next;
    next = next->next;
  };
  /*
   * Inserts the device between 'prev' and 'next'.
   */
  xw->next = next;
  if(prev==NULL)
    device_list = xw;
  else
    prev->next = xw;
  return xw;
}

