/*.......................................................................
 * Initializes the color representations in the color table.
 * xw_get_visual() must have been called prior to calling this function,
 * so that we have a visual and colormap to define the colors in.
 *
 * Input:
 *  xw      XWdev *    The MFPLOT /xw device descriptor.
 * Output:
 *  xw->color.xcolor[0..ncol] The color pixel definitions.
 *  return    int      0 - OK.
 *                     1 - Error.
 */
static int xw_init_colors ( XWdev *xw ) {
  /*
   * Define the standard MFPLOT line colors (RGB).
   *    16 old PGPLOT colors
   *    7  old MATLAB colors
   *    7  new MATLAB colors
   *   12  BREEZE colortable
   */
  static double ctable[NCOLORS][3] = {
    {0.0,0.0,0.0}, {1.0,1.0,1.0}, {1.0,0.0,0.0}, {0.0,1.0,0.0},
    {0.0,0.0,1.0}, {0.0,1.0,1.0}, {1.0,0.0,1.0}, {1.0,1.0,0.0},
    {0.003922,0.003922,0.003922},
    {0.1647,0.1647,0.1647}, {0.3333,0.3333,0.3333}, {0.5000,0.5000,0.5000},
    {0.6667,0.6667,0.6667}, {0.8314,0.8314,0.8314}, {0.9961,0.9961,0.9961},
    {1.0,1.0,1.0},
    {0.00,0.00,1.00}, {0.00,0.50,0.00}, {1.00,0.00,0.00},
    {0.00,0.75,0.75}, {0.75,0.00,0.75}, {0.75,0.75,0.00},
    {0.25,0.25,0.25},
    {0.000,0.447,0.741}, {0.850,0.325,0.098}, {0.929,0.694,0.125},
    {0.494,0.184,0.556}, {0.466,0.674,0.188}, {0.301,0.745,0.933},
    {0.635,0.078,0.184},
    {0.2392,0.6824,0.9137}, {0.9294,0.0824,0.0824}, {0.9647,0.4549,0.0000},
    {0.9922,0.7373,0.2941}, {0.1529,0.6824,0.3765}, {0.7882,0.8078,0.2314},
    {0.0667,0.8196,0.0863}, {0.1608,0.5020,0.7255}, {0.6078,0.3490,0.7137},
    {0.4980,0.5490,0.5529}, {0.1020,0.7373,0.6118}, {0.7529,0.2235,0.1686}
  };
  /*
   * In PGPLOT, original was white on black
   * ( Background = ctable[0] = {0.0,0.0,0.0}
   *   Foreground = ctable[1] = {1.0,1.0,1.0} )
   */
  if( BLACK_ON_WHITE == 1 ) {
    ctable[0][0] = 1.;
    ctable[0][1] = 1.;
    ctable[0][2] = 1.;
    ctable[1][0] = 0.;
    ctable[1][1] = 0.;
    ctable[1][2] = 0.;
  };
  int i;
  /*
   * Initializes the color-table with the standard MFPLOT line colors.
   */
  if(!xw->color.monochrome) {
    int ncol = (NCOLORS < xw->color.ncol) ? NCOLORS : xw->color.ncol;
    for(i=0; i<ncol; i++) {
      if(xw_set_rgb(xw, i, ctable[i][0], ctable[i][1], ctable[i][2]))
        return 1;
    };
  /*
   * Initializes the rest of the colors with a constant grey value
   */

  /*
    for(i=ncol; i<xw->color.ncol; i++) {
      double grey = (double)(i-NCOLORS) / (double)(xw->color.ncol-1-NCOLORS);
   */
  /*    for(i=ncol; i<ncol+256; i++) { */
    for(i=ncol; i<XW_MAX_COLORS; i++) {
      double grey = 0.5;
      if(xw_set_rgb(xw, i, grey, grey, grey)) return 1;
    };

  };
  /*
   * Flushes the new color definitions to the display.
   */
  if(xw_update_colors(xw)) return 1;
  /*
   * Records the new colormap state.
   */
  xw->color.initialized = 1;
  /*
   * Starts with the foreground color set to white.
   */
  if( xw_set_ci(xw,1) ) return 1;
  return 0;
}
