/*.......................................................................
 * From their RGB values, writes pixels into an image
 * (xw_image_line modifiée en xw_image_line_RGB)
 *-----------------------------------------------------------------------
 * Draw a horizontal line of pixels at a given location, from a double
 * array of color RGB values.
 *
 * Input:
 *  xw      XWdev *   The MFPLOT /xw device descriptor.
 *  start  XPoint *   The position to start the line at.
 *  cells     int *   An array of ncell pixel RGB values.
 *  ncell     int     The number of cells in cells[].
 * Output:
 *  return    int     0 - OK.
 *                    1 - Error.
 */

static int xw_image_line_RGB ( XWdev *xw, XPoint *start,
                               int *cells, int ncell ) {
  int ndone;  /* The number of pixels drawn so far */
  int i;
  /*
   * Device error?
   */
  if(xw->bad_device) return 1;
  /*
   * Quietly ignores the call if we don't have a pixmap.
   */
  if(pixmap_ID != None) {
    /*
     * Draws up to xw->image.npix pixels at a time. This is the size of the
     * xw->image.buff[] buffer.
     */
    for(ndone=0; !xw->bad_device && ndone<ncell; ndone += XW_IMAGE_LEN) {
      int ntodo = ncell-ndone;
      int nimage = ntodo < XW_IMAGE_LEN ? ntodo : XW_IMAGE_LEN;
      /*
       * Loads the image buffer with the RGB value.
       */
      if(xw->color.vi->depth == 8) {
        for(i=0; i<nimage; i++)
          xw->image.xi->data[i] = xw_nint(cells[ndone+i]);
      } else {
        for(i=0; i<nimage; i++) {
          XPutPixel( xw->image.xi, i, 0, xw_nint(cells[ndone+i]) );
        };
      };
      /*
       * Displays the image.
       */
      XPutImage( xw->display, pixmap_ID, xw->gc, xw->image.xi, 0, 0,
                 start->x+ndone, start->y, (unsigned) nimage, (unsigned) 1 );
    };
    /*
     * Extends the region to be updated on the next flush.
     */
    xw_mark_modified(xw, start->x, start->y, 1);
    xw_mark_modified(xw, start->x + ncell - 1, start->y, 1);
  };

  return 0;
}

