/*.......................................................................
 * Set up the visual and colormap for the /xw window.
 *
 * Input:
 *  xw      XWdev *    The MFPLOT /xw device descriptor.
 * Output:
 *  xw->color.vi               The info descriptor of the visual to be used.
 *  xw->color.cmap             The ID of the colormap to use.
 *  xw->color.ncol             The number of colors available.
 *  xw->color.pixel[0..ncol]   The color cell pixel indexes.
 *  xw->color.xcolor[0..ncol]  The color pixel definitions.
 *  xw->color.monochrome       If true, use black and white instead of the
 *                             above values.
 *  xw->color.nbuff            The number of buffered color representations.
 *  xw->color.sbuff            The index of the first buffered color rep.
 *
 *  return   int     0 - OK.
 *                   1 - Error.
 */
static int xw_get_visual ( XWdev *xw ) {

  XWindowAttributes attr;
  /*
   * Device error?
   */
  if ( xw->bad_device ) return 1;
  /*
   * Assumes that we have a monochrome display until proven otherwise.
   */
  xw->color.monochrome = 1;
  xw->color.ncol = 2;
  xw->color.nbuff = 0;  /* No color representations buffered yet */
  xw->color.sbuff = 0;
  /*
   * Inquires the current visual details of the window.
   */
  if ( !XGetWindowAttributes(xw->display, xw->window, &attr) ) {
    fprintf( stderr,
             "%s: (xw_get_visual) Error getting attributes for window 0x%lx.\n",
             XW_IDENT, (unsigned long) xw->window );
    return 1;
  };
  xw->color.cmap = attr.colormap;
  if ( xw->color.vi == NULL || xw->color.cmap == None ) return 1;
  /*
   * Other colormap details.
   */
  xw->color.monochrome = 0;
  xw->color.ncol = XW_MAX_COLORS;
  /*
   * Allocates memory for the array of color pixels and color pixel
   * representations.
   */
  if ( xw->color.ncol > 0 ) {
    xw->color.pixel = (unsigned long *) malloc(sizeof(unsigned long) * xw->color.ncol);
    xw->color.xcolor = (XColor *) malloc(sizeof(XColor) * xw->color.ncol);
    if ( xw->color.pixel==NULL || xw->color.xcolor==NULL )
      xw->color.ncol = 0;
  };
  return 0;
}
