/*
 * See opcode 36
 */

static void xw_get_string_bbox ( XWdev *xw, char *chr,
                                 int *ex, int *ey, int *ew, int *eh ) {

  XftFont *font;
  XGlyphInfo extents;

  /* here, we use the display of xw, but we don't write anything.
   */

  xw_set_fontconfig_path ();

  xft_angle = 0.;
  font = XftFontOpenName( xw->display, DefaultScreen(xw->display),
                          xft_fontname, &xft_angle );
  if( font == 0 ) {
    fprintf( stderr, " (Muesli FGL:) x11_driver: xw_get_string_bbox: internal error.\n" );
    fprintf( stderr, "               XftFontOpenName failed!\n" );
    fprintf( stderr, "\n -> pause for debugging purpose...\n" );
    getchar();
    fprintf( stderr, " *** ABORTING ***\n" );
    exit(1);
  }

  /* Get extent of the string in pixels (no rotation) */
  if( xft_string_utf8 == 1 ) {
    XftTextExtentsUtf8( xw->display, font, (XftChar8 *)chr, strlen(chr), &extents );
  } else {
    XftTextExtents8( xw->display, font, (XftChar8 *)chr, strlen(chr), &extents );
  }

  /* glyph metric:         --+--------------+--
   *                         |      |       |
   *                         |    _ |     _ |
   *                       3 |   / \|    / \|
   *                         |  |   |   |   |
   *                         |   \_/    |\_/| 4
   *                       --+----------|---+
   *                         |          |   |
   *                         |          |   |
   *                         +--------------+--
   *                         |1 |    2      |
   */
  *ex = extents.x;      /* 1 (here negative) */
  *ey = extents.y;      /* 3 */
  *ew = extents.width;  /* 2 */
  *eh = extents.height; /* 4 */

  XftFontClose ( xw->display, font );

}

