/*.......................................................................
 * Reads the RGB values of pixels inside an image
 * (xw_image_line modifiée en xw_get_image_line_RGB)
 *-----------------------------------------------------------------------
 * Read an horizontal line of pixels at a given location, and writes a
 * double array of MFPLOT color indexes.
 *
 * Input:
 *  xw      XWdev *   The MFPLOT /xw device descriptor.
 *  start  XPoint *   The position to start the line at.
 *  cells     int *   An array of ncell RGB values packed in an integer.
 *  ncell     int     The number of cells in cells[].
 * Output:
 *  return    int     0 - OK.
 *                    1 - Error.
 */

static int xw_get_image_line_RGB ( XWdev *xw, XPoint *start,
                                   int *cells, int ncell ) {
  int i;

  /*
   * Device error?
   */
  if ( xw->bad_device ) return 1;

  /*
   * Quietly ignores the call if we don't have a pixmap.
   */
  if ( pixmap_ID != None ) {
    /*
     * Get the image.
     */
    EC_ximage = XGetImage ( xw->display, pixmap_ID, start->x, start->y,
                            (unsigned) ncell, (unsigned) 1,
                            (unsigned long) 0xFFFFFF, ZPixmap );
    if ( EC_ximage == 0 ) return 1;
    /*
     * Reads the image buffer.
     */
    if ( xw->color.vi->depth == 8 ) {
      /* je ne sais pas comment faire dans ce cas ! */
      XDestroyImage ( EC_ximage );
      return 1;
    } else {
      for (i=0; i<ncell; i++) {
        cells[i] = XGetPixel ( EC_ximage, i, 0 );
      };
      XDestroyImage ( EC_ximage );
    };
  };

  return 0;
}

