/*.......................................................................
 * Allocates the contents of xw->image. This contains buffers used to
 * construct and dispatch line-of-pixel images to the display.
 *
 * Note that xw_get_visual() must have been called before this function.
 *
 * Input:
 *  xw    XWdev * The MFPLOT /xw device descriptor.
 *  npix    int   The length of the buffer in pixels.
 * Output:
 *  return  int   0 - OK.
 *                1 - Error.
 */

static int xw_get_image ( XWdev *xw, int npix ) {
  /*
   * Create the X image that we use to compose lines of pixels with given
   * colors.
   */
  xw->image.xi = XCreateImage(xw->display, xw->color.vi->visual,
                              (unsigned)xw->color.vi->depth, ZPixmap, 0,
                              NULL, (unsigned)npix, 1, 32, 0);
  if(xw->image.xi==NULL) {
    fprintf( stderr, "%s: Failed to allocate XImage container.\n", XW_IDENT );
    return 1;
  };
  /*
   * Allocates the image buffer.
   */
  xw->image.xi->data = malloc((size_t) xw->image.xi->bytes_per_line);
  if(!xw->image.xi->data) {
    fprintf( stderr, "%s: Failed to allocate image buffer.\n", XW_IDENT );
    return 1;
  };
  return 0;
}
