/*.......................................................................
 * Gets a mouse click in the window
 *-----------------------------------------------------------------------
 *
 * Input:
 *  xw    XWdev * The MFPLOT /xw device descriptor.
 *
 * Output:
 *  return  int   0 - Nothing
 *                1 - A click (ButtonRelease) occured in window
 */

static int xw_get_click ( XWdev *xw ) {
  XEvent event;           /* The latest event */
  int clicked=0;          /* True if clicked  */

  /*
   * Device error?
   */
  if(xw->bad_device) return 0;
  XSync(xw->display, False);
  if(xw->bad_device) return 0;

  /*
   * Makes sure that the window is up to date.
   */
  if(xw_flush(xw)) return 0;

  /*
   * Catches a ButtonRelease without blocking.
   */
  xw_add_events(xw, (long)(ButtonReleaseMask));
  while(xw_check_window_event(xw, xw->window,
                              (long)(ButtonReleaseMask), &event))
    clicked = 1;

  return clicked;
}
