/*.......................................................................
 * Flushes changes of the pixmap to the window.
 *
 * Input:
 *  xw    XWdev *  The MFPLOT /xw device descriptor.
 * Output:
 *  return  int    0 - OK.
 *                 1 - Error.
 */
static int xw_flush ( XWdev *xw ) {

  if ( xw->bad_device ) return 1;

  if ( FLUSH_ENABLED != 1 && FORCE_FLUSH == 0 ) return 0;

  /*
   * Flushes buffered opcodes if necessary.
   */
  if ( xw->flush_opcode_fn != (Flush_Opcode_fn) 0 ) {
    (*xw->flush_opcode_fn)(xw);
    xw->flush_opcode_fn = (Flush_Opcode_fn) 0;
    if ( xw->bad_device ) return 1;
    XFlush ( xw->display );
  };

  /*
   * Copies the modified rectangular area of the pixmap to the /xw window.
   */
  if ( xw->update.modified ) {
    /*
     * Enforces bounds on the area to be updated.
     */
    if ( xw->update.xmin < 0 ) xw->update.xmin = 0;
    if ( xw->update.ymin < 0 ) xw->update.ymin = 0;
    if ( xw->update.xmax > xw->geom.width - 1 ) xw->update.xmax = xw->geom.width - 1;
    if ( xw->update.ymax > xw->geom.height - 1 ) xw->update.ymax = xw->geom.height - 1;
    /*
     * Copies the area to be updated from the pixmap to the window.
     * Uses the 2nd GC, which never have a ClipMask.
     */
    if ( xw->pixmap != None && !xw->bad_device ) {
      XCopyArea ( xw->display, xw->pixmap, xw->window, xw->gc2,
                  xw->update.xmin, xw->update.ymin,
                  (unsigned) (xw->update.xmax - xw->update.xmin + 1),
                  (unsigned) (xw->update.ymax - xw->update.ymin + 1),
                  xw->update.xmin, xw->update.ymin );
      if ( xw->bad_device ) return 1;
      xw->update.modified = 0;
      XFlush ( xw->display );
    };
  };

  return 0;
}

