/*.......................................................................
 * Call this function when an Expose event is received. It will then
 * re-draw the exposed region from the xw->pixmap.
 *
 * Input:
 *  xw       XWdev *  The MFPLOT /xw device descriptor.
 *  event   XEvent *  The expose event.
 * Output:
 *  return     int    0 - OK.
 *                    1 - Error.
 */
static int xw_expose ( XWdev *xw, XEvent *event ) {
  /*
   * Device error?
   */
  if( xw->bad_device ) return 1;
  if( event->type == Expose && xw->pixmap != None ) {
    XCopyArea( xw->display, xw->pixmap, xw->window, xw->gc,
               event->xexpose.x, event->xexpose.y,
               (unsigned) event->xexpose.width, (unsigned) event->xexpose.height,
               event->xexpose.x, event->xexpose.y );
    XFlush( xw->display );
  };
  return 0;
}

