/*.......................................................................
 * This function is called by X11 whenever a non-fatal error occurs
 * on a given display connection.
 *
 * Input:
 *  display    Display *  The display connection on which the error occured.
 *  event  XErrorEvent *  The descriptor of the error event.
 * Output:
 *  return         int    The return value is not specified by Xlib, so
 *                        we will simply return 0.
 */
static int xw_error ( Display *display, XErrorEvent *event ) {
  char errtxt[81]; /* Buffer to receive error message in */
  XWdev *xw;
  /*
   * Finds the device that is the source of the error.
   */
  for(xw=device_list; xw!=NULL && xw->display!=display; xw = xw->next);
  /*
   * If a device was located, checks if the error implies that server
   * resources have become unusable for that device.
   */
  if(xw && !xw->bad_device) {
    xw->last_error = event->error_code;
    switch(event->error_code) {
    case BadAtom: case BadColor: case BadCursor: case BadDrawable:
    case BadGC: case BadIDChoice: case BadPixmap: case BadWindow:
      /*
       * Gets a message describing the error.
       */
      XGetErrorText(display, (int)event->error_code,errtxt,(int)sizeof(errtxt));
      fprintf( stderr, "%s: XErrorEvent: %s\n", XW_IDENT, errtxt );
      /*
       * Reports the operation that caused it. These opcode numbers are listed
       * in <X11/Xproto.h>.
       */
      fprintf( stderr, "%s: Major opcode of failed request: %d\n", XW_IDENT,
               (int) event->request_code );
      /*
       * Reports the loss of the window and marks the device as unusable.
       */
      xw_bad_device(xw);
      break;
    };
  };
  return 0;
}

