/* The output area is a small area, near the bottom-left corner, where
 * some useful information, like pointer position, is written.
 * This area needs to be erased between two writes, or when the pointer
 * leaves the axes.
 */

void xw_erase_output_area( XWdev *xw ) {
  unsigned long white = 0xFFFFFF, black = 0x0, background;
  if( BLACK_ON_WHITE ) {
    background = white;
  } else {
    background = black;
  }
  XSetForeground( xw->display, xw->gc2, background );
  XFillRectangle( xw->display, xw->window, xw->gc2, 2, xw->geom.height-18,
                  150, 16 );
  XSetForeground( xw->display, xw->gc2, 1-background ); /* avoid side effects */
}

