/*
 * See opcode 140
 */

static void xw_erase_labelling_area ( XWdev *xw,
                                      int x_axis_time, int y_axis_time ) {

  int ci, x, y, lw;
  unsigned long fg;
  unsigned int width, height;
  int HALF_AXIS_LABEL_HEIGHT = AXIS_LABEL_HEIGHT/2;

  /* Save GC values */
  fg = xw->gcv.foreground;
  lw = xw->gcv.line_width;

  /* Select the background color */
  ci = 0; /* 0 is always the background color, whatever the mode used
            (i.e. white-on-black or black-on-white) */
  xw->gcv.foreground = xw->color.pixel[ci];
  xw->gcv.line_width = AXIS_LABEL_HEIGHT;
  /* Using xw->gc2 which is never clipped */
  XChangeGC ( xw->display, xw->gc2, GCForeground | GCLineWidth, &xw->gcv );

  x = VP_TLC.x - HALF_AXIS_LABEL_HEIGHT;
  y = VP_TLC.y - HALF_AXIS_LABEL_HEIGHT;
  width  = VP_BRC.x + 1 + HALF_AXIS_LABEL_HEIGHT - x;
  height = VP_BRC.y + 1 + HALF_AXIS_LABEL_HEIGHT - y;

  XDrawRectangle ( xw->display, xw->pixmap, xw->gc2,
                   x, y, width, height );

  xw_mark_modified(xw, x, y, AXIS_LABEL_HEIGHT);
  xw_mark_modified(xw, x+width, y+height, AXIS_LABEL_HEIGHT);

  if ( x_axis_time ) {
    /* This additional erasing is done only if XOPT_SAVE contains 'Z'
     * (cf. PGTBOX) */
    int x_start, y_start, x_end, y_end;
    x_start = xw->geom.xmargin;
    y_start = VP_BRC.y + 1 + HALF_AXIS_LABEL_HEIGHT;
    x_end = VP_BRC.x + 3*HALF_AXIS_LABEL_HEIGHT;
    y_end = y_start;
    XDrawLine ( xw->display, xw->pixmap, xw->gc2,
                x_start, y_start, x_end, y_end );
    xw_mark_modified(xw, x_start, y_start, AXIS_LABEL_HEIGHT);
    xw_mark_modified(xw, x_end, y_end, AXIS_LABEL_HEIGHT);
  }

  if ( y_axis_time ) {
    /* This additional erasing is done only if YOPT_SAVE contains 'Z'
     * (cf. PGTBOX) */
    int x_start, y_start, x_end, y_end;
    x_start = x;
    y_start = xw->geom.ymargin;
    x_end = x_start;
    y_end = xw->geom.height - xw->geom.ymargin;
    XDrawLine ( xw->display, xw->pixmap, xw->gc2,
                x_start, y_start, x_end, y_end );
    xw_mark_modified(xw, x_start, y_start, AXIS_LABEL_HEIGHT);
    xw_mark_modified(xw, x_end, y_end, AXIS_LABEL_HEIGHT);
  }

  xw_flush(xw);

  /* restore GC values */
  xw->gcv.foreground = fg;
  xw->gcv.line_width = lw;
  XChangeGC ( xw->display, xw->gc2, GCForeground | GCLineWidth, &xw->gcv );

}

