/*.......................................................................
 * Erases a previously drawn cursor.
 *
 * Input:
 *  xw   XWdev *   The MFPLOT /xw device descriptor.
 *  bc    Band *   A cursor descriptor returned by xw_new_band().
 * Output:
 *  return int     0 - OK.
 *                 1 - Error.
 */
static int xw_erase_cursor ( XWdev *xw, Band *bc ) {
  /*
   * Erases the cursor.
   */
  switch(bc->mode) {
  case 0: default:
    if(xw->crosshair) {
      if(xw_cursor_line(xw, 0, bc->end.y, (int)xw->geom.width-1,bc->end.y) ||
         xw_cursor_line(xw, bc->end.x, 0, bc->end.x, (int)xw->geom.height-1))
        return 1;
    };
    break;
  case 1:   /* Line cursor */
    if(xw_cursor_line(xw, bc->ref.x, bc->ref.y, bc->end.x, bc->end.y))
      return 1;
    break;
  case 2: case 8: /* Rectangle cursor */
    if(xw_cursor_line(xw, bc->ref.x, bc->ref.y, bc->ref.x, bc->end.y) ||
       xw_cursor_line(xw, bc->ref.x, bc->end.y, bc->end.x, bc->end.y) ||
       xw_cursor_line(xw, bc->end.x, bc->end.y, bc->end.x, bc->ref.y) ||
       xw_cursor_line(xw, bc->end.x, bc->ref.y, bc->ref.x, bc->ref.y))
      return 1;
    break;
  case 3: /* Two horizontal lines */
    if(xw_cursor_line(xw, 0, bc->end.y, (int)xw->geom.width-1,bc->end.y) ||
       xw_cursor_line(xw, 0, bc->ref.y, (int)xw->geom.width-1,bc->ref.y))
      return 1;
    break;
  case 4: /* Two vertical lines */
    if(xw_cursor_line(xw, bc->end.x, 0, bc->end.x, (int)xw->geom.height-1) ||
       xw_cursor_line(xw, bc->ref.x, 0, bc->ref.x, (int)xw->geom.height-1))
      return 1;
    break;
  case 5: /* One horizontal line through the cursor */
    if(xw_cursor_line(xw, 0, bc->end.y, (int)xw->geom.width-1,bc->end.y))
      return 1;
    break;
  case 6: /* One vertical line through the cursor */
    if(xw_cursor_line(xw, bc->end.x, 0, bc->end.x, (int)xw->geom.height-1))
      return 1;
    break;
  case 7: /* Cross hair */
    if(xw_cursor_line(xw, 0, bc->end.y, (int)xw->geom.width-1,bc->end.y) ||
       xw_cursor_line(xw, bc->end.x, 0, bc->end.x, (int)xw->geom.height-1))
      return 1;
    break;
  case 101: /* Display a custom cursor */
    XCopyArea( xw->display, xw->pixmap, xw->window, xw->gc,
               bc->end.x, bc->end.y, 16, 16, bc->end.x, bc->end.y );
    break;
  };
  return 0;
}

