/*.......................................................................
 * Private function of xw_read_cursor().
 *
 * Input:
 *  xw    XWdev *   The MFPLOT /xw device descriptor.
 *  bc     Band *   The cursor banding descriptor to be deleted.
 *  status  int     Required xw_read_cursor() return status.
 * Output:
 *  return  int     The value of 'status'.
 */
static int xw_end_cursor ( XWdev *xw, Band *bc, int status ) {
  if(bc) {
    if( xw_erase_cursor(xw, bc) ) status = 1;
    if( xw_flush(xw) ) status = 1;
    bc = xw_del_Band(xw, bc);
  };

  return status;
}

