/*.......................................................................
 * See opcode 33
 */
static void xw_draw_string ( XWdev *xw, char *chr, XPoint *xy ) {

  XftDraw *xftdraw;
  XftFont *font;
  XGlyphInfo extents;
  XRenderColor xrcolor;
  XftColor xftcolor;
  int xA, yA, xB, yB;
  int ci;
  int must_be_drawn;
  XRectangle rectangles[1]; /* Array of rectangles (here, only one) */

  if( pixmap_ID == xw->pixmap ) {
    xftdraw = xw->xftdraw_pixmap;
  } else if( pixmap_ID == xw->pixmap_aux_1 ) {
    xftdraw = xw->xftdraw_pixmap_aux_1;
  } else if( pixmap_ID == xw->pixmap_aux_2 ) {
    xftdraw = xw->xftdraw_pixmap_aux_2;
  } else {
    fprintf( stderr, " (Muesli FGL:) x11_driver: xw_draw_string: internal error.\n" );
    fprintf( stderr, "               Bad pixmap_ID!\n" );
    return;
  }
  if( !xftdraw ) {
    xftdraw = XftDrawCreate( xw->display, pixmap_ID,
                   DefaultVisual(xw->display,DefaultScreen(xw->display)),
                   DefaultColormap(xw->display,DefaultScreen(xw->display)) );
    if( pixmap_ID == xw->pixmap ) {
      xw->xftdraw_pixmap = xftdraw;
    } else if( pixmap_ID == xw->pixmap_aux_1 ) {
      xw->xftdraw_pixmap_aux_1 = xftdraw;
    } else if( pixmap_ID == xw->pixmap_aux_2 ) {
      xw->xftdraw_pixmap_aux_2 = xftdraw;
    }
  }

  xw_set_fontconfig_path ();

  /* The full fontname is store under the following forms:
   *   "Helvetica-12.5",  "Helvetica-12.5:Bold"
   *   "Times-12.5",      "Times-12.5;Italic"
   *   "Times-12.5:Bold", "Times-12.5:Bold:Italic"
   *   "Symbol-12.5",     "English 157-12.5"
   */

  /* Try to re-use a previous font */
  if( xw->font && (xw->xft_angle == xft_angle)
               && (strcmp(xw->xft_fontname,xft_fontname) == 0) ) {
    font = xw->font;
  } else {
    if( xw->font ) XftFontClose( xw->display, xw->font );
    font = XftFontOpenName( xw->display, DefaultScreen(xw->display),
                            xft_fontname, &xft_angle );
    if( !font ) {
      fprintf( stderr, " (Muesli FGL:) x11_driver: xw_draw_string: internal error.\n" );
      fprintf( stderr, "               XftFontOpenName failed!\n" );
      fprintf( stderr, "\n -> pause for debugging purpose...\n" );
      getchar();
      fprintf( stderr, " *** ABORTING ***\n" );
      exit(1);
    }
    /* record the font for re-using it */
    xw->font = font;
    xw->xft_angle = xft_angle;
    strcpy(xw->xft_fontname,xft_fontname);
  }

  /* Get extent of the string in pixels (rotation is taken into account) */
  if( xft_string_utf8 == 1 ) {
    XftTextExtentsUtf8( xw->display, font,
                        (XftChar8 *)chr, strlen(chr), &extents );
  } else {
    XftTextExtents8( xw->display, font,
                     (XftChar8 *)chr, strlen(chr), &extents );
  }

  /* zone of interest:
   *                       A +----------+
   *                         |          |
   *                         +----------+ B
   */
  xA = xy->x - extents.x;
  yA = xy->y - extents.y;
  xB = xA + extents.width;
  yB = yA + extents.height;

  must_be_drawn = 1;

//XftDrawDelClipRectangles( xftdraw ); /* Don't work! */
  /* workaround: setting to a very large rectangle to simulate no clipping */
  rectangles[0].x = 0;
  rectangles[0].y = 0;
  rectangles[0].width  = 30000;
  rectangles[0].height = 30000;
  XftDrawSetClipRectangles( xftdraw, 0, 0, rectangles, 1 );

  /* if clipping, we must perhaps truncate this area to the viewport */
  if( xft_clipping == 1 ) {
    if( xA < BRC.x ) {
      if( yA < BRC.y ) {
        if( xB > TLC.x ) {
          if( yB > TLC.y ) {
            xA = MAX(xA,TLC.x);
            yA = MAX(yA,TLC.y);
            xB = MIN(xB,BRC.x);
            yB = MIN(yB,BRC.y);
            /* Define the rectangle for the clipping zone */
//            rectangles[0].x = 0; /* already set to zero few lines above */
//            rectangles[0].y = 0;
            rectangles[0].width  = xB-xA+1;
            rectangles[0].height = yB-yA+1;
            XftDrawSetClipRectangles( xftdraw, xA, yA, rectangles, 1 );
          } else {
            must_be_drawn = 0;
          }
        } else {
          must_be_drawn = 0;
        }
      } else {
        must_be_drawn = 0;
      }
    } else {
      must_be_drawn = 0;
    }
  }

  if ( must_be_drawn ) {
    if( last_color_index == -1 ) {
      fprintf( stderr, " (Muesli FGL:) x11_driver: xw_draw_string: internal error.\n" );
      fprintf( stderr, "               last_color_index not set!\n" );
      fprintf( stderr, "\n -> pause for debugging purpose...\n" );
      getchar();
      fprintf( stderr, " *** ABORTING ***\n" );
      exit(1);
    }
    ci = last_color_index;
    xrcolor.red = COLORMULT * xw_xcolor_to_rgb(xw->color.xcolor[ci].red);
    xrcolor.green = COLORMULT * xw_xcolor_to_rgb(xw->color.xcolor[ci].green);
    xrcolor.blue = COLORMULT * xw_xcolor_to_rgb(xw->color.xcolor[ci].blue);
    xrcolor.alpha = COLORMULT; /* = 0xffff -> opaque */

    XftColorAllocValue( xw->display,
                        DefaultVisual(xw->display,DefaultScreen(xw->display)),
                        DefaultColormap(xw->display,DefaultScreen(xw->display)),
                        &xrcolor, &xftcolor );

    if( xft_string_utf8 == 1 ) {
      XftDrawStringUtf8( xftdraw, &xftcolor, font, xy->x, xy->y,
                         (XftChar8 *)chr, strlen(chr) );
    } else {
      XftDrawString8( xftdraw, &xftcolor, font, xy->x, xy->y,
                      (XftChar8 *)chr, strlen(chr) );
    }

    if ( DRAW_IN_AUX == 0 ) {
      xw_mark_modified(xw, xA, yA, 1);
      xw_mark_modified(xw, xB, yB, 1);
    }
  }

}

