/*
 * Used by opcode 103.
 *
 * Currently, this function is a translation (and adaptation) of the Fortran
 * routine 'pgarro'.
 */

static void xw_draw_arrow ( XWdev *xw ) {

/*
  Working only in dev. coords.

  Constants:
    xs2 = grxmxa(grcide)
    ys2 = grymxa(grcide)
    dh = ch*min(abs(xs2),abs(ys2))/40.0d0       ( dhx = dhy = dh )

 */

  double rbuf[8];
  int i, j;
  int xmin = 1e6, ymin = 1e6, xmax = -1, ymax = -1;
  double x2, y2, xp, yp, xm, ym;
  double param1 = 0.35;
  double co = -0.92387953251128674, so = 0.38268343236508978;
  double dh, ca, sa;
  double dx, dy, dr;

  /* Set attributes for the arrow */
  xw_set_ci(xw, ARROW_CI);
  xw->gcv.line_width = (int)(ARROW_LW*0.005 * xw->geom.xpix_per_inch);
  XChangeGC(xw->display, xw->gc, GCLineWidth, &xw->gcv);

  dh = ARROW_DH;
  x2 = ARROW_END.x;
  y2 = ARROW_END.y;

  dx = ARROW_END.x - ARROW_START.x;
  dy = ARROW_END.y - ARROW_START.y;
  dr = sqrt( dx*dx + dy*dy );
  ca = dx / dr;
  sa = dy / dr;

  xp = dh*(ca*co - sa*so);
  yp = dh*(sa*co + ca*so);

  xm = dh*(ca*co + sa*so);
  ym = dh*(sa*co - ca*so);

  rbuf[0] = x2;
  rbuf[1] = y2;
  rbuf[2] = x2 + xp;
  rbuf[3] = y2 + yp;
  rbuf[4] = x2 + param1*(xp+xm);
  rbuf[5] = y2 + param1*(yp+ym);
  rbuf[6] = x2 + xm;
  rbuf[7] = y2 + ym;

  xw->poly.npoint = 4;
  xw->poly.points = (XPoint *) malloc(sizeof(XPoint) * xw->poly.npoint);

  for (i=0; i<xw->poly.npoint; i++) {
    j = 2*i;
    XPoint *xp = &xw->poly.points[i];
    xp->x = xw_nint( rbuf[j] );
    xp->y = xw_nint( rbuf[j+1] );
    if ( xp->x < xmin ) xmin = xp->x;
    if ( xp->y < ymin ) ymin = xp->y;
    if ( xp->x > xmax ) xmax = xp->x;
    if ( xp->y > ymax ) ymax = xp->y;
  }

  if ( CLIPPED_OBJ ) {
    XFillPolygon ( xw->display, pixmap_ID, xw->gc, xw->poly.points,
                   xw->poly.npoint, Complex, CoordModeOrigin );
  } else {
    XFillPolygon ( xw->display, pixmap_ID, xw->gc2, xw->poly.points,
                   xw->poly.npoint, Complex, CoordModeOrigin );
  }
  free((char *)xw->poly.points);
  xw->poly.points = NULL;
  if ( DRAW_IN_AUX == 0 ) {
    xw_mark_modified(xw, xmin, ymin, 1);
    xw_mark_modified(xw, xmax, ymax, 1);
  }

  if ( CLIPPED_OBJ ) {
    XDrawLine ( xw->display, pixmap_ID, xw->gc,
                ARROW_START.x, ARROW_START.y, ARROW_END.x, ARROW_END.y );
  } else {
    XDrawLine ( xw->display, pixmap_ID, xw->gc2,
                ARROW_START.x, ARROW_START.y, ARROW_END.x, ARROW_END.y );
  }
  if ( DRAW_IN_AUX == 0 ) {
    xw_mark_modified ( xw, ARROW_START.x, ARROW_START.y, xw->gcv.line_width );
    xw_mark_modified ( xw, ARROW_END.x, ARROW_END.y, xw->gcv.line_width );
  }
  xw_flush(xw);

}

