/*.......................................................................
 * Draw a string directly on the window (i.e. without pixmap).
 * This volatile way is well adapted to put the pointer position near a
 * window corner.
 */
static void xw_direct_draw_string ( XWdev *xw, char *chr, XPoint *xy ) {

  XftFont *font;
  XRenderColor xrcolor;
  XftColor xftcolor;
  int ci;
  double xft_angle = 0;
  char xft_fontname[80];

  if( !xw->xftdraw_no_pixmap ) {
    xw->xftdraw_no_pixmap = XftDrawCreate( xw->display, xw->window,
                     DefaultVisual(xw->display,DefaultScreen(xw->display)),
                     DefaultColormap(xw->display,DefaultScreen(xw->display)) );
  }

  xw_set_fontconfig_path ();

  /* This following fontsize should be clear enough, except perhaps on
   * high-dpi screens */
  strcpy(xft_fontname, "Helvetica-9.5");

  /* Try to re-use a previous font */
  if( xw->font && (xw->xft_angle == xft_angle)
               && (strcmp(xw->xft_fontname,xft_fontname) == 0) ) {
    font = xw->font;
  } else {
    if( xw->font ) XftFontClose( xw->display, xw->font );
    font = XftFontOpenName( xw->display, DefaultScreen(xw->display),
                            xft_fontname, &xft_angle );
    if( !font ) {
      fprintf( stderr, " (Muesli FGL:) x11_driver: xw_direct_draw_string: internal error.\n" );
      fprintf( stderr, "               XftFontOpenName failed!\n" );
      fprintf( stderr, "\n -> pause for debugging purpose...\n" );
      getchar();
      fprintf( stderr, " *** ABORTING ***\n" );
      exit(1);
    }
    /* record the font for re-using it */
    xw->font = font;
    xw->xft_angle = xft_angle;
    strcpy(xw->xft_fontname,xft_fontname);
  }

  ci = 1; /* foreground color */
  xrcolor.red = COLORMULT * xw_xcolor_to_rgb(xw->color.xcolor[ci].red);
  xrcolor.green = COLORMULT * xw_xcolor_to_rgb(xw->color.xcolor[ci].green);
  xrcolor.blue = COLORMULT * xw_xcolor_to_rgb(xw->color.xcolor[ci].blue);
  xrcolor.alpha = COLORMULT; /* = 0xffff -> opaque */
  XftColorAllocValue( xw->display,
                      DefaultVisual(xw->display,DefaultScreen(xw->display)),
                      DefaultColormap(xw->display,DefaultScreen(xw->display)),
                      &xrcolor, &xftcolor );

  XftDrawString8( xw->xftdraw_no_pixmap, &xftcolor, font, xy->x, xy->y,
                  (XftChar8 *)chr, strlen(chr) );

}

