/*.......................................................................
 * Deletes a MFPLOT /xw device and its descriptor.
 *
 * Input:
 *  xw      XWdev *  The descriptor of the device to be deleted.
 *  partial   int    0 - Normal deletion - delete everything.
 *                   1 - Close the display connection and mark all
 *                       resources as deleted but don't delete the
 *                       container - also set xw->bad_device=1.
 * Output:
 *  return  XWdev *  Allways NULL. Use like xw = xw_del_XWdev(xw,0);
 */
static XWdev * xw_del_XWdev (XWdev *xw, int partial ) {
  if(xw) {
    /*
     * Marks the device as unusable as the first operation so that if
     * any X errors are generated during cleanup, they are not reported.
     */
    xw->bad_device = 1;
    /*
     * Deletes the graphical context descriptors.
     */
    if(xw->gc)
      XFreeGC(xw->display, xw->gc);
    xw->gc = NULL;
    if(xw->gc2)
      XFreeGC(xw->display, xw->gc2);
    xw->gc2 = NULL;
    /*
     * Deletes the image buffers.
     */
    if(xw->image.xi)
      XDestroyImage(xw->image.xi);
    xw->image.xi = NULL;
    /*
     * Checks for un-freed polygon points.
     */
    if(xw->poly.points)
      free((char *)xw->poly.points);
    xw->poly.points = NULL;
    /*
     * Zaps the arrays of color pixels and color pixel definitions.
     */
    if(xw->color.pixel)
      free((char *)xw->color.pixel);
    if(xw->color.xcolor)
      free((char *)xw->color.xcolor);
    /*
     * Discards the visual info descriptor.
     */
    if(xw->color.vi)
      XFree((char *)xw->color.vi);

    XFreeCursor(xw->display, xw->norm_cursor);
    XFreeCursor(xw->display, xw->live_cursor);
    XFreeCursor(xw->display, xw->resize_cursor);
    XFreeCursor(xw->display, xw->watch_cursor);
    XFreeCursor(xw->display, xw->hand1_cursor);
    XFreeCursor(xw->display, xw->hand2_cursor);
    XFreeCursor(xw->display, xw->zoom_cursor);

    if( xw->xftdraw_no_pixmap ) {
      XftDrawDestroy( xw->xftdraw_no_pixmap );
      xw->xftdraw_no_pixmap = NULL;
    }
    if( xw->xftdraw_pixmap ) {
      XftDrawDestroy( xw->xftdraw_pixmap );
      xw->xftdraw_pixmap = NULL;
    }
    if( xw->xftdraw_pixmap_aux_1 ) {
      XftDrawDestroy( xw->xftdraw_pixmap_aux_1 );
      xw->xftdraw_pixmap_aux_1 = NULL;
    }
    if( xw->xftdraw_pixmap_aux_2 ) {
      XftDrawDestroy( xw->xftdraw_pixmap_aux_2 );
      xw->xftdraw_pixmap_aux_2 = NULL;
    }

    if( xw->pixmap != None ) {
      XFreePixmap( xw->display, xw->pixmap );
      xw->pixmap = None;
    }
    if( xw->pixmap_aux_1 != None ) {
      XFreePixmap( xw->display, xw->pixmap_aux_1 );
      xw->pixmap_aux_1 = None;
    }
    if( xw->pixmap_aux_2 != None ) {
      XFreePixmap( xw->display, xw->pixmap_aux_2 );
      xw->pixmap_aux_2 = None;
    }

    if( xw->font ) {
      XftFontClose( xw->display, xw->font );
      xw->font = NULL;
    }

    /*
     * Closes the connection to the display server - this will also delete
     * all X-resources.
     */
    if(xw->display != NULL) {
      /*
       * Explicitly clears the local event mask for the MFPLOT /xw window
       * in case XCloseDisplay fails to do this.
       */
      if(xw->window != None)
        XSelectInput(xw->display, xw->window, (long) NoEventMask);
      XCloseDisplay(xw->display);
      xw->display = NULL;
    };
    /*
     * Marks effected resources as deleted.
     */
    xw->window = xw->parent = None;
    if( pixmap_ID == xw->pixmap ) {
      pixmap_ID = None;
    }
    xw->pixmap = None;

    xw->norm_cursor   = None;
    xw->live_cursor   = None;
    xw->resize_cursor = None;
    xw->watch_cursor  = None;
    xw->hand1_cursor  = None;
    xw->hand2_cursor  = None;
    xw->zoom_cursor   = None;

    xw->flush_opcode_fn = (Flush_Opcode_fn) 0;
    xw->update.modified = 0;
    /*
     * Deletes the descriptor if required.
     */
    if(!partial) {
      free((char *)xw);
      xw = NULL;
    };
  };
  return xw;
}
