/*.......................................................................
 * Releases band cursor resources and return the window event mask to
 * its normal state.
 *
 * Input:
 *  xw    XWdev *   The MFPLOT /xw device descriptor.
 *  bc     Band *   The band-cursor descriptor.
 * Output:
 *  return Band *   Always NULL.
 */
static Band * xw_del_Band (XWdev *xw, Band *bc ) {
  /*
   * Prevent the event buffer from overflowing by removing superflous events
   * from the set of those to be caught.
   */
  xw_rem_events(xw, (long) (ExposureMask | KeyPressMask | KeyReleaseMask |
                            ButtonPressMask | ButtonReleaseMask |
                            EnterWindowMask | LeaveWindowMask |
                            PointerMotionMask));
  /*
   * If the line width was changed for rubber banding, re-instate the
   * original line width.
   */
  if(bc->line_width != xw->gcv.line_width)
    XChangeGC(xw->display, xw->gc, (unsigned long) GCLineWidth, &xw->gcv);
  return NULL;
}

