/*.......................................................................
 * Reads the current position of the cursor
 *-----------------------------------------------------------------------
 *
 * Input:
 *  xw    XWdev * The MFPLOT /xw device descriptor.
 *
 * Output:
 *  loc  XPoint * The located position of the cursor, if it is in
 *                the window.
 *  return  int   0 - Cursor not in window -
 *                1 - Cursor is in window - 'loc' records the position.
 */

static int xw_current_pos ( XWdev *xw, XPoint *loc ) {
  XWindowAttributes attr; /* Current window attributes */
  Window p_child;         /* The child of /xw (None) containing the pointer */
  int p_win_x, p_win_y;   /* The pointer coordinates in xw->window */
  int p_root_x, p_root_y; /* The pointer coordinates in the root window */
  Window p_root_win;      /* The root window containing the cursor */
  unsigned int p_mask;    /* Bit mask of button states etc.. */
  int inwindow=0;         /* True if the cursor is in the window */

  /*
   * Device error?
   */
  if(xw->bad_device) return 0;
  /*
   * Queries the current state of the window.
   */
  XSync(xw->display, False);
  if(xw->bad_device) return 0;
  XGetWindowAttributes(xw->display, xw->window, &attr);
  if(xw->bad_device) return 0;
  /*
   * Determines the current position of the pointer.
   */
  XQueryPointer(xw->display, xw->window, &p_root_win, &p_child,
                &p_root_x, &p_root_y, &p_win_x, &p_win_y, &p_mask);
  if(xw->bad_device) return 0;
  /*
   * Is the cursor within the bounds of the window?
   */
  inwindow = ((attr.map_state != IsUnmapped) &&
              (p_win_x >= 0 && p_win_x < attr.width) &&
              (p_win_y >= 0 && p_win_y < attr.height));
  /*
   * Returns the current position of the cursor.
   */
  loc->x = p_win_x;
  loc->y = p_win_y;

  return inwindow;
}

