/*.......................................................................
 * See opcodes 84 and 85
 */
static void xw_clip_at_viewport ( XWdev *xw ) {

  XRectangle rectangles[1]; /* Array of rectangles (here, only one) */

  if( !viewport_defined ) {
    printf("X11 driver: xw_clip_at_viewport: ERROR: viewport not yet defined!\n");
    printf("  (pause for debugging purpose only)\n");
    getchar();
    abort();
  }

  /* Update the graphics context.
   * Below, there is a reduction of 0 or 1 pixel around all sides of the
   * viewport, according the value of CLIP_VP_CORR.
   * If CLIP_VP_CORR = 0, this is the standard viewport;
   * whereas using CLIP_VP_CORR leads to a smaller area to avoid some colored
   * pixel overwriting the framebox. */
  rectangles[0].x = 0;
  rectangles[0].y = 0;
  rectangles[0].width  = VP_BRC.x - VP_TLC.x + 1 - 2*CLIP_VP_CORR;
  rectangles[0].height = VP_BRC.y - VP_TLC.y + 1 - 2*CLIP_VP_CORR;
  XSetClipRectangles ( xw->display, xw->gc,
                       VP_TLC.x+CLIP_VP_CORR, VP_TLC.y+CLIP_VP_CORR,
                       rectangles, 1, Unsorted );

}

