/*.......................................................................
 * Clears an auxiliary pixmap.
 *-----------------------------------------------------------------------
 *
 * Input:
 *  xw      XWdev *   The MFPLOT /xw device descriptor.
 *
 */

static void xw_clear_pixmap_aux ( XWdev *xw, Pixmap pixmap ) {

  Window root;
  int x, y;
  unsigned int width, height, border, depth;
  GC gc;

  /*
   * Device error?
   */
  if ( xw->bad_device ) return;

  /* Gets width and height of the main pixmap */
  XGetGeometry ( xw->display, pixmap, &root, &x, &y,
                 &width, &height, &border, &depth );

  gc = XDefaultGC ( xw->display, DefaultScreen(xw->display) );
  if ( BLACK_ON_WHITE ) {
    XSetForeground ( xw->display, gc, XWhitePixel(xw->display,xw->screen) );
  } else {
    XSetForeground ( xw->display, gc, XBlackPixel(xw->display,xw->screen) );
  }
  XFillRectangle ( xw->display, pixmap, gc, 0, 0, width, height );

}

